ORCA/M Asm65816 2.1.0

0001 D000              ;==========================================================
0002 D000              ;
0003 D000              ;  init.data
0004 D000              ;
0005 D000              ;  Data structure area for the GS/OS initialization package.
0006 D000              ;
0007 D000              ;  Author:      Andy Stadler
0008 D000              ;  Created:     12-Jan-87
0009 D000              ;  Modified:    See modification history below
0010 D000              ;
0011 D000              ;  Copyright (C) 1987-1989 Apple Computer, Inc.
0012 D000              ;  All Rights Reserved.
0013 D000              ;
0014 D000              ;=============================================================================
0015 D000              ;
0016 D000              ;  Modification history:
0017 D000              ;
0018 D000              ;  01-Feb-88    ADS     Initial release
0019 D000              ;  15-Feb-88    ADS     Text mode stuff
0020 D000              ;  23-Feb-88    ADS     Slid screen stuff around for 'fmt too large'
0021 D000              ;                       indicators
0022 D000              ;  06-Apr-88    CAE     added 'which_class' variable
0023 D000              ;  25-Jul-88    CAE     removed leading spaces from format strings
0024 D000              ;                       changed 'k' to 'K'
0025 D000              ;  10-Aug-88    FAB     at pubs request (orders) restored leading spaces in
0026 D000              ;                       format strings.  Also changed 'Mb' to
0027 D000              ;                       ' MB' and 'Gb' to ' GB' again at pubs request.
0028 D000              ;  21-Dec-88    CAE     added msg_flag, msg_window, save_port, msg_parms
0029 D000              ;  12-Jan-89    CAE     moved scr_save_buf here from equates
0030 D000              ;  23-Mar-89    CAE     added 'dot_five' string
0031 D000              ;=============================================================================
0032 D000
0033 D000              init_data Proc Export                   ;can't be a Record 'cause of AsmIIGS bug
0034 D000                       Import draw_window
0035 D000                       with fmt_list_record,fst_list_record
0036 D000
0037 D000              ;  non-page-zero variables
0038 D000
0039 D000                       EXPORT which_class
0040 D000 00 00        which_class DC W:0
0041 D002                       EXPORT which_call
0042 D002 00 00        which_call DC W:0
0043 D004                       Export my_dp
0044 D004 00 00        my_dp    DC W:0
0045 D006                       EXPORT save_cursor
0046 D006 00 00 00 00  save_cursor DC L:0
0047 D00A                       EXPORT cons_dev_num
0048 D00A 00 00        cons_dev_num DC W:0
0049 D00C                       EXPORT vid_state
0050 D00C 00 00        vid_state DC W:0
0051 D00E                       EXPORT console_state
0052 D00E 00 00        console_state DC W:0
0053 D010
0054 D010              ;msg_flag = 0 if the 'Initializing...' message was not put up
0055 D010              ;         = 1 if the message was put up in graphics mode
0056 D010              ;         = -1 if the message was put up in text mode
0057 D010
0058 D010                       EXPORT msg_flag
0059 D010 00 00        msg_flag DC W:0                         ;Added CAE 12/21/88
0060 D012                       EXPORT msg_window
0061 D012 00 00 00 00  msg_window DC L:0                       ;Added CAE 12/21/88
0062 D016                       EXPORT save_port
0063 D016 00 00 00 00  save_port DC L:0                        ;Added CAE 12/21/88
0064 D01A                       EXPORT scr_save_buf
0065 D01A 00 00 00 00  scr_save_buf DC L:0                     ;Added CAE 1/12/89
0066 D01E                       Export currentFST
0067 D01E 00 00        currentFST DS W:1                       ;stores FST ID of currently selected FST
0068 D020                       Export path_vp
0069 D020 00 00 00 00  path_vp  DS L:1                         ;stores VP of volume name after it's entered
0070 D024                       Export save_in_port
0071 D024 00 00 00 00  save_in_port DS L:1                     ;VP of saved Input Port record
0072 D028                       Export save_term_list
0073 D028 00 00 00 00  save_term_list DS L:1                   ;VP of saved terminator list
0074 D02C                       Export save_list_len
0075 D02C 00 00        save_list_len DS W:1                    ;length of saved terminator list
0076 D02E                       Export save_dflt_string
0077 D02E 00 00 00 00  save_dflt_string DS L:1                 ;VP of saved default string
0078 D032                       Export dflt_string_len
0079 D032 00 00        dflt_string_len DS W:1                  ;length of saved default string
0080 D034
0081 D034              ; used in add_size_str procedure
0082 D034                       Export dest_buffer
0083 D034 00 00 00 00  dest_buffer DS B:dest_length
0084 D044
0085 D044              ; alert window definition table
0086 D044
0087 D044                       EXPORT init_wnd_parms
0088 D044 4E 00        init_wnd_parms DC W:end_wnd_parms-init_wnd_parms
0089 D046 20 20                 DC W:$2020                     ; alert, visible
0090 D048 00 00 00 00           DC L:0                         ; no title
0091 D04C 00 00 00 00           DC L:0                         ; refcon
0092 D050 00 00 00 00           DC L:0                         ; zoom size
0093 D054 00 00 00 00           DC L:0                         ; zoom size
0094 D058 00 00 00 00           DC L:0                         ; default colors
0095 D05C 00 00 00 00           DC L:0                         ; origin point
0096 D060 00 00 00 00           DC L:0                         ; content size
0097 D064 00 00 00 00           DC L:0                         ; max grow size
0098 D068 00 00 00 00           DC L:0                         ; arrow scroll distance
0099 D06C 00 00 00 00           DC L:0                         ; page scroll distance
0100 D070 00 00 00 00           DC L:0                         ; info refcon
0101 D074 00 00                 DC W:0                         ; info bar height
0102 D076 00 00 00 00           DC L:0                         ; std frame defproc
0103 D07A 00 00 00 00           DC L:0                         ; info bar defproc
0104 D07E A0 DA 00 00           DC L:draw_window               ; content defproc
0105 D082 1E 00 78 00           DC W:30,120                    ; top left corner
0106 D086 B2 00 08 02           DC W:178,520                   ; bottom right corner
0107 D08A FF FF FF FF           DC L:-1                        ; topmost window
0108 D08E 00 00 00 00           DC L:0                         ; no memory yet
0109 D092              ;	EXPORT	end_wnd_parms
0110 D092              end_wnd_parms  
0111 D092
0112 D092
0113 D092              ; 'Initializing...' alert window definition table
0114 D092
0115 D092                       EXPORT msg_parms               ;Added CAE 12/21/88
0116 D092 4E 00        msg_parms DC W:end_msg_parms-msg_parms
0117 D094 20 20                 DC W:$2020                     ; alert, visible
0118 D096 00 00 00 00           DC L:0                         ; no title
0119 D09A 00 00 00 00           DC L:0                         ; refcon
0120 D09E 00 00 00 00           DC L:0                         ; zoom size
0121 D0A2 00 00 00 00           DC L:0                         ; zoom size
0122 D0A6 00 00 00 00           DC L:0                         ; default colors
0123 D0AA 00 00 00 00           DC L:0                         ; origin point
0124 D0AE 00 00 00 00           DC L:0                         ; content size
0125 D0B2 00 00 00 00           DC L:0                         ; max grow size
0126 D0B6 00 00 00 00           DC L:0                         ; arrow scroll distance
0127 D0BA 00 00 00 00           DC L:0                         ; page scroll distance
0128 D0BE 00 00 00 00           DC L:0                         ; info refcon
0129 D0C2 00 00                 DC W:0                         ; info bar height
0130 D0C4 00 00 00 00           DC L:0                         ; std frame defproc
0131 D0C8 00 00 00 00           DC L:0                         ; info bar defproc
0132 D0CC 00 00 00 00           DC L:0                         ; content defproc
0133 D0D0 5A 00 DC 00           DC W:90,220                    ; top left corner
0134 D0D4 6E 00 A4 01           DC W:110,420                   ; bottom right corner
0135 D0D8 FF FF FF FF           DC L:-1                        ; topmost window
0136 D0DC 00 00 00 00           DC L:0                         ; no memory yet
0137 D0E0              ;	EXPORT	end_msg_parms
0138 D0E0              end_msg_parms  
0139 D0E0
0140 D0E0                        
0141 D0E0              ;  rect into which the 'fst too large' warning fits
0142 D0E0
0143 D0E0              numLines equ   4
0144 D0E0              msgTop   equ   87
0145 D0E0                       EXPORT warn_rect
0146 D0E0 57 00        warn_rect DC W:msgTop                   ;Rect to display message in
0147 D0E2 14 00                 DC W:20
0148 D0E4 7B 00                 DC W:(numLines*9)+msgTop
0149 D0E6 7C 01                 DC W:380
0150 D0E8
0151 D0E8                       Export first_rect
0152 D0E8 57 00        first_rect DC W:msgTop                  ;Rect to display initial message in
0153 D0EA 50 00                 DC W:80                        ;(leave enough room for the 'Caution' icon)
0154 D0EC 7B 00                 DC W:(numLines*9)+msgTop
0155 D0EE 7C 01                 DC W:380
0156 D0F0
0157 D0F0              dfltTop  equ   128
0158 D0F0              dfltLeft equ   237
0159 D0F0              dfltBottom equ   dfltTop+15
0160 D0F0              dfltRight equ   dfltLeft+90
0161 D0F0
0162 D0F0              CancelTop equ   dfltTop
0163 D0F0              CancelLeft equ   73
0164 D0F0              CancelBottom equ   CancelTop+15
0165 D0F0              CancelRight equ   CancelLeft+90
0166 D0F0
0167 D0F0                       Export MyControls
0168 D0F0 30 D1 01 00  MyControls DC L:CancelButton
0169 D0F4 08 D1 01 00           DC L:defaultButton
0170 D0F8 86 D1 01 00           DC L:list2_rec
0171 D0FC 58 D1 01 00           DC L:list1_rec
0172 D100 B4 D1 01 00           DC L:editLine
0173 D104 00 00 00 00           DC L:0
0174 D108
0175 D108                       Export dflt_title
0176 D108 09 00        defaultButton DC W:9                    ;Param count
0177 D10A 02 00 00 00           DC L:defaultButtonID           ;Control #
0178 D10E 80 00                 DC W:dfltTop                   ;control rect
0179 D110 ED 00                 DC W:dfltLeft
0180 D112 8F 00                 DC W:dfltBottom
0181 D114 47 01                 DC W:dfltRight
0182 D116 00 00 00 80           DC L:$80000000                 ;Simple button
0183 D11A 00 00                 DC W:0                         ;Flags (single outline button)
0184 D11C 00 30                 DC W:$3000                     ;More flags
0185 D11E 00 00 00 00           DC L:0                         ;Refcon
0186 D122 00 00 00 00  dflt_title DC L:0                       ;title pointer
0187 D126 00 00 00 00           DC L:0                         ;No color table
0188 D12A 0D                    DC B:$0d                       ;key equivalent = carriage return
0189 D12B 0D                    DC B:$0d
0190 D12C 00 01                 DC W:%0000000100000000         ;Open-Apple modifier needed
0191 D12E 00 01                 DC W:%0000000100000000
0192 D130
0193 D130                       Export cancel_title
0194 D130 09 00        CancelButton DC W:9                     ;Param count
0195 D132 01 00 00 00           DC L:CancelButtonID            ;Control #
0196 D136 80 00                 DC W:CancelTop
0197 D138 49 00                 DC W:CancelLeft
0198 D13A 8F 00                 DC W:CancelBottom
0199 D13C A3 00                 DC W:CancelRight
0200 D13E 00 00 00 80           DC L:$80000000                 ;Simple button
0201 D142 00 00                 DC W:0                         ;Flags
0202 D144 00 30                 DC W:$3000                     ;More flags
0203 D146 00 00 00 00           DC L:0                         ;Refcon
0204 D14A 00 00 00 00  cancel_title DC L:0                     ;Title Pointer
0205 D14E 00 00 00 00           DC L:0                         ;No color table
0206 D152 1B                    DC B:$1b                       ;key equivalent = ESC
0207 D153 1B                    DC B:$1b
0208 D154 00 00                 DC W:0                         ;no modifiers needed
0209 D156 00 00                 DC W:0
0210 D158
0211 D158              ;  fst list record - graphics list manager
0212 D158
0213 D158                       EXPORT list1_size,list1_ref
0214 D158              list1_rec  
0215 D158 0E 00                 DC W:14                        ;pCount
0216 D15A 03 00 00 00           DC L:fstListID                 ;control ID
0217 D15E 27 00 28 00           DC W:39,40                     ;rect
0218 D162 51 00 A0 00           DC W:81,160
0219 D166 00 00 00 89           DC L:listControl               ;procref
0220 D16A 40 00                 DC W:$0040                     ;flags
0221 D16C 00 54                 DC W:fCtlProcRefNotPtr+\
0222 D16E                       fCtlCanBeTarget+\ 
0223 D16E                       fCtlIsMultiPart                ;moreflags
0224 D16E 00 00 00 00           DC L:0                         ;refcon
0225 D172 00 00        list1_size DC W:0                       ;listSize
0226 D174 04 00                 DC W:4                         ;listView
0227 D176 02 00                 DC W:2                         ;listType (single selections, pStrings)
0228 D178 01 00                 DC W:1                         ;listStart
0229 D17A 00 00 00 00           DC L:0                         ;listDraw
0230 D17E 0A 00                 DC W:10                        ;listMemHeight
0231 D180 20 00                 DC W:ff_size                   ;listMemSize
0232 D182 00 00 00 00  list1_ref DC L:0                        ;listRef
0233 D186
0234 D186              ;  fmt list record - graphics list manager
0235 D186
0236 D186                       EXPORT list2_size,list2_ref
0237 D186              list2_rec  
0238 D186 0E 00                 DC W:14                        ;pCount
0239 D188 04 00 00 00           DC L:intrlvListID              ;control ID
0240 D18C 27 00 D8 00           DC W:39,216                    ;rect
0241 D190 51 00 50 01           DC W:81,336
0242 D194 00 00 00 89           DC L:listControl               ;procref
0243 D198 40 00                 DC W:$0040                     ;flags
0244 D19A 00 54                 DC W:fCtlProcRefNotPtr+\
0245 D19C                       fCtlCanBeTarget+\ 
0246 D19C                       fCtlIsMultiPart                ;moreflags
0247 D19C 00 00 00 00           DC L:0                         ;refcon
0248 D1A0 00 00        list2_size DC W:0                       ;listSize
0249 D1A2 04 00                 DC W:4                         ;listView
0250 D1A4 02 00                 DC W:2                         ;listType (single selections, pStrings)
0251 D1A6 01 00                 DC W:1                         ;listStart
0252 D1A8 00 00 00 00           DC L:0                         ;listDraw
0253 D1AC 0A 00                 DC W:10                        ;listMemHeight
0254 D1AE 1E 00                 DC W:df_size                   ;listMemSize
0255 D1B0 00 00 00 00  list2_ref DC L:0                        ;listRef
0256 D1B4
0257 D1B4                       Export editLine,name_default
0258 D1B4 08 00        editLine DC W:8                         ;pCount
0259 D1B6 05 00 00 00           DC L:editLineID                ;ID
0260 D1BA 12 00 41 00           DC W:18,65                     ;rect
0261 D1BE 1F 00 68 01           DC W:31,360
0262 D1C2 00 00 00 83           DC L:editLineControl           ;procRef
0263 D1C6 00 00                 DC W:0                         ;flags
0264 D1C8 00 70                 DC W:fCtlCanBeTarget+\
0265 D1CA                       fCtlWantEvents+\ 
0266 D1CA                       fCtlProcRefNotPtr              ;moreFlags
0267 D1CA 00 00 00 00           DC L:0                         ;refCon
0268 D1CE 20 00                 DC W:32                        ;maxSize
0269 D1D0 00 00 00 00  name_default DC L:0                     ;defaultRef
0270 D1D4
0271 D1D4              ; fst list record - text list 'manager'
0272 D1D4
0273 D1D4                       EXPORT tx_list_1
0274 D1D4              tx_list_1  
0275 D1D4 00 00 00 00           DC L:0                         ; member list ptr
0276 D1D8 31 2A                 DC B:17+32,10+32               ; port to draw list in
0277 D1DA 44 2E                 DC B:36+32,14+32
0278 D1DC 00 00                 DC W:0                         ; number entries in list
0279 D1DE 00 00                 DC W:0                         ; current selection
0280 D1E0 00 00                 DC W:0                         ; top displayed entry
0281 D1E2 20 00                 DC W:ff_size                   ; list entry size
0282 D1E4
0283 D1E4              ; fmt list record - text list 'manager'
0284 D1E4
0285 D1E4                       EXPORT tx_list_2
0286 D1E4              tx_list_2  
0287 D1E4 00 00 00 00           DC L:0                         ; member list ptr
0288 D1E8 4B 2A                 DC B:43+32,10+32               ; port to draw list in
0289 D1EA 5E 2E                 DC B:62+32,14+32
0290 D1EC 00 00                 DC W:0                         ; number entries in list
0291 D1EE 00 00                 DC W:0                         ; current selection
0292 D1F0 00 00                 DC W:0                         ; top displayed entry
0293 D1F2 1E 00                 DC W:df_size                   ; list entry size
0294 D1F4
0295 D1F4
0296 D1F4              ; event record for event manager
0297 D1F4
0298 D1F4                       Export TaskRecord,TaskData4
0299 D1F4              TaskRecord  
0300 D1F4 00 00        EventWhat DS W:1
0301 D1F6 00 00 00 00  EventMessage DS W:2
0302 D1FA 00 00 00 00  EventWhen DS W:2
0303 D1FE 00 00 00 00  EventWhere DS W:2
0304 D202 00 00        EventModifiers DS W:1
0305 D204 00 00 00 00  TaskData DS W:2
0306 D208 06 00 13 00  TaskMask DC L:tmIdleEvents+\
0307 D20C                       tmControlKey+\ 
0308 D20C                       tmContentControls+\ 
0309 D20C                       tmFindW+\ 
0310 D20C                       tmUpdate+\ 
0311 D20C                       0                              ;to make editing easier!
0312 D20C 00 00 00 00           DC L:0                         ;wmLastClickTick
0313 D210 00 00                 DC W:0                         ;wmClickCount
0314 D212 00 00 00 00           DC L:0                         ;wmTaskData2
0315 D216 00 00 00 00           DC L:0                         ;wmTaskData3
0316 D21A 00 00 00 00  TaskData4 DC L:0                        ;wmTaskData4
0317 D21E 00 00 00 00           DC L:0                         ;wmLastClockPt
0318 D222
0319 D222
0320 D222              ; strings for make_fmt_str routine
0321 D222              ; (moved here to get more space in bank 0 language card area)
0322 D222
0323 D222                       string Pascal
0324 D222 06 20 62 79  bytes_string DC B:' bytes'
0325 D229
0326 D229 01 4B        kb_string DC B:'K'
0327 D22B
0328 D22B 03 20 4D 42  mb_string DC B:' MB'
0329 D22F
0330 D22F 03 20 47 42  gb_string DC B:' GB'
0331 D233
0332 D233                       EXPORT two_spaces
0333 D233 02 20 20     two_spaces DC B:'  '
0334 D236
0335 D236                       EXPORT colon_one
0336 D236 02 3A 31     colon_one DC B:':1'
0337 D239
0338 D239                       EXPORT dot_five
0339 D239 02 2E 35     dot_five DC B:'.5'                      	
0340 D23C
0341 D23C                       String AsIs
0342 D23C
0343 D23C                       EXPORT fmt_str_tb
0344 D23C 22 D2 01 00  fmt_str_tb DC L:bytes_string
0345 D240 29 D2 01 00           DC L:kb_string
0346 D244 2B D2 01 00           DC L:mb_string
0347 D248 2F D2 01 00           DC L:gb_string
0348 D24C
0349 D24C                       ENDP 
0350 D24C
0351 D24C              pb_stuff Record 
0352 D24C                       export pb_reqFileSysID
0353 D24C 00 00        pb_reqFileSysID DS W:1                  ; reqFileSysID parameter
0354 D24E                       export pb_flags
0355 D24E 00 00        pb_flags DS W:1                         ; flags parameter
0356 D250                       EndR 
0357 D250
0358 D250              ;==========================================================
0359 D250              ;
0360 D250              ;  file init.3
0361 D250              ;
0362 D250              ;  Contains the data segment and text interface portions of
0363 D250              ;  the init package.
0364 D250              ;
0365 D250              ;  Author:      Andy Stadler
0366 D250              ;  Created:     29-Jan-88
0367 D250              ;  Modified:    See modification history below
0368 D250              ;
0369 D250              ;  Copyright (C) 1988-1989 Apple Computer, Inc.
0370 D250              ;  All Rights Reserved.
0371 D250              ;
0372 D250              ;==========================================================
0373 D250
0374 D250                       eject 
0375 D250              ;==========================================================
0376 D250              ;
0377 D250              ;  jsl  get_string
0378 D250              ;
0379 D250              ;  Looks up the specified string from the error messages.
0380 D250              ;
0381 D250              ;  Inputs:      A = string #
0382 D250              ;
0383 D250              ;  Outputs:     X,Y = pointer to string
0384 D250              ;               A = trashed
0385 D250              ;               X = trashed
0386 D250              ;               Y = trashed
0387 D250              ;               P = nvmxdizc
0388 D250              ;                   ..000...
0389 D250              ;
0390 D250              ;  uses init_temp_1
0391 D250              ;
0392 D250              ;==========================================================
0393 D250
0394 D250              get_string Proc Export
0395 D250                       Import get_msg_address
0396 D250
0397 D250                       with my_direct_page
0398 D250
0399 D250 1A                    inc   a                        ; calc table offset
0400 D251 0A                    asl   a
0401 D252 0A                    asl   a
0402 D253 85 AA                 sta   <init_temp_1
0403 D255
0404 D255 F4 00 00              pea   get_msg_address>>16
0405 D258 F4 AB B2              pea   get_msg_address
0406 D25B F4 00 00              pea   0
0407 D25E 22 87 B1 00           jsl   >lc_dispatcher
0408 D262
0409 D262 8A                    txa                            ; index into table
0410 D263 18                    clc   
0411 D264 65 AA                 adc   <init_temp_1
0412 D266 85 AA                 sta   <init_temp_1
0413 D268 98                    tya   
0414 D269 69 00 00              adc   #0
0415 D26C 85 AC                 sta   <init_temp_1+2
0416 D26E
0417 D26E A7 AA                 lda   [<init_temp_1]           ; calc string start
0418 D270 18                    clc   
0419 D271 65 AA                 adc   <init_temp_1
0420 D273
0421 D273 AA                    tax   
0422 D274 A4 AC                 ldy   <init_temp_1+2
0423 D276 6B                    rtl   
0424 D277
0425 D277                       ENDP 
0426 D277
0427 D277                       eject 
0428 D277              ;==========================================================
0429 D277              ;
0430 D277              ;  deref_lists
0431 D277              ;
0432 D277              ;  fmt_list_vp  ->  fmt_list_ptr
0433 D277              ;  fst_list_vp  ->  fst_list_ptr
0434 D277              ;
0435 D277              ;  Inputs:      fmt_list_vp = VP of available formats
0436 D277              ;               fst_list_vp = VP of available file systems.
0437 D277              ;
0438 D277              ;  Outputs:     A = trashed
0439 D277              ;               X = trashed
0440 D277              ;               Y = trashed
0441 D277              ;               P = nvmxdizc
0442 D277              ;                   ..000...
0443 D277              ;
0444 D277              ;==========================================================
0445 D277
0446 D277              deref_lists Proc Export
0447 D277                       Import call_deref
0448 D277                       with my_direct_page
0449 D277
0450 D277 A6 80                 ldx   <fmt_list_vp
0451 D279 A4 82                 ldy   <fmt_list_vp+2
0452 D27B 22 08 D4 00           jsl   call_deref
0453 D27F 86 84                 stx   <fmt_list_ptr
0454 D281 84 86                 sty   <fmt_list_ptr+2
0455 D283
0456 D283 A6 90                 ldx   <fst_list_vp
0457 D285 A4 92                 ldy   <fst_list_vp+2
0458 D287 22 08 D4 00           jsl   call_deref
0459 D28B 86 94                 stx   <fst_list_ptr
0460 D28D 84 96                 sty   <fst_list_ptr+2
0461 D28F
0462 D28F 6B                    rtl   
0463 D290                       EndP 
0464 D290
0465 D290                       eject 
0466 D290              ;==========================================================
0467 D290              ;
0468 D290              ;  call_open
0469 D290              ;
0470 D290              ;  Open the console driver!
0471 D290              ;
0472 D290              ;  Outputs:     A = error code IF C = 1
0473 D290              ;               X = trashed
0474 D290              ;               Y = trashed
0475 D290              ;               P = nvmxdizc
0476 D290              ;                   ..000..|
0477 D290              ;                          0 if opened OK, 1 if not
0478 D290              ;
0479 D290              ;==========================================================
0480 D290
0481 D290              call_open Proc 
0482 D290 AD 0A D0              lda   |cons_dev_num
0483 D293 85 00                 sta   <drvr_dev_num
0484 D295 A9 01 00              lda   #drvr_open
0485 D298 85 02                 sta   <drvr_call_num
0486 D29A 22 18 D4 00           jsl   >call_dispatch
0487 D29E 60                    rts   
0488 D29F                       EndP 
0489 D29F
0490 D29F                       eject 
0491 D29F              ;==========================================================
0492 D29F              ;
0493 D29F              ;  call_status
0494 D29F              ;
0495 D29F              ;  Perform a status call to the console driver.  This only
0496 D29F              ;  works for a max of 2 bytes of data because it always
0497 D29F              ;  uses std_buffer.  The driver is called with a request
0498 D29F              ;  count of 2.
0499 D29F              ;
0500 D29F              ;  Outputs:     std_buffer = contains data returned
0501 D29F              ;               <drvr_tran_cnt = transferred data count
0502 D29F              ;               A = error code IF C = 1
0503 D29F              ;               X = trashed
0504 D29F              ;               Y = trashed
0505 D29F              ;               P = nvmxdizc
0506 D29F              ;                   ..000..|
0507 D29F              ;                          0 if status OK, 1 if not
0508 D29F              ;
0509 D29F              ;==========================================================
0510 D29F
0511 D29F              call_status Proc 
0512 D29F 85 16                 sta   <drvr_stat_code
0513 D2A1 A9 05 00              lda   #drvr_status
0514 D2A4 80 05                 bra   common_call              ; rest is shared with call_control
0515 D2A6
0516 D2A6                       eject 
0517 D2A6              ;==========================================================
0518 D2A6              ;
0519 D2A6              ;  call_control
0520 D2A6              ;
0521 D2A6              ;  Perform a control call to the console driver.  This only
0522 D2A6              ;  works for a max of 2 bytes of data because it always
0523 D2A6              ;  uses std_buffer.  The driver is called with a request
0524 D2A6              ;  count of 2.
0525 D2A6              ;
0526 D2A6              ;  Outputs:     std_buffer = contains data to send
0527 D2A6              ;               <drvr_tran_cnt = transferred data count
0528 D2A6              ;               A = error code IF C = 1
0529 D2A6              ;               X = trashed
0530 D2A6              ;               Y = trashed
0531 D2A6              ;               P = nvmxdizc
0532 D2A6              ;                   ..000..|
0533 D2A6              ;                          0 if status OK, 1 if not
0534 D2A6              ;
0535 D2A6              ;  console_dispatch - calls the console driver directly.
0536 D2A6              ;
0537 D2A6              ;  Inputs:      A = low byte of request count (high byte always 0)
0538 D2A6              ;               X = low word of control list pointer
0539 D2A6              ;               Y = high word of control list pointer
0540 D2A6              ;               drvr_ctrl_code and drvr_call_num must be
0541 D2A6              ;               initialized prior to entering console_dispatch.
0542 D2A6              ; 
0543 D2A6              ;==========================================================
0544 D2A6                       Entry call_control,console_dispatch
0545 D2A6              call_control  
0546 D2A6 85 16                 sta   <drvr_ctrl_code
0547 D2A8 A9 06 00              lda   #drvr_control
0548 D2AB
0549 D2AB              ; from here down is shared by call_status
0550 D2AB
0551 D2AB              common_call  
0552 D2AB 85 02                 sta   <drvr_call_num
0553 D2AD A2 B6 B2              ldx   #<std_buffer
0554 D2B0 A0 00 00              ldy   #^std_buffer
0555 D2B3 A9 02 00              lda   #2
0556 D2B6
0557 D2B6              console_dispatch  
0558 D2B6 85 08                 sta   <drvr_req_cnt
0559 D2B8 64 0A                 stz   <drvr_req_cnt+2
0560 D2BA 86 04                 stx   <drvr_slist_ptr
0561 D2BC 84 06                 sty   <drvr_slist_ptr+2
0562 D2BE AD 0A D0              lda   |cons_dev_num
0563 D2C1 85 00                 sta   <drvr_dev_num
0564 D2C3 22 18 D4 00           jsl   >call_dispatch
0565 D2C7 60                    rts   
0566 D2C8                       EndP 
0567 D2C8
0568 D2C8                       eject 
0569 D2C8              ;==========================================================
0570 D2C8              ;
0571 D2C8              ;  call_close
0572 D2C8              ;
0573 D2C8              ;  done, close that puppy!
0574 D2C8              ;
0575 D2C8              ;  Outputs:     A = error code IF C = 1
0576 D2C8              ;               X = trashed
0577 D2C8              ;               Y = trashed
0578 D2C8              ;               P = nvmxdizc
0579 D2C8              ;                   ..000..|
0580 D2C8              ;                          0 if closed OK, 1 if not
0581 D2C8              ;
0582 D2C8              ;==========================================================
0583 D2C8
0584 D2C8              call_close Proc 
0585 D2C8 AD 0A D0              lda   |cons_dev_num
0586 D2CB 85 00                 sta   <drvr_dev_num
0587 D2CD A9 04 00              lda   #drvr_close
0588 D2D0 85 02                 sta   <drvr_call_num
0589 D2D2 22 18 D4 00           jsl   >call_dispatch
0590 D2D6 60                    rts   
0591 D2D7                       EndP 
0592 D2D7
0593 D2D7                       eject 
0594 D2D7              ;==========================================================
0595 D2D7              ;
0596 D2D7              ;  get_input_port
0597 D2D7              ;
0598 D2D7              ;  Performs a GetInputPort call to the console driver
0599 D2D7              ;
0600 D2D7              ;  Outputs:     A = error code IF C = 1
0601 D2D7              ;               X = trashed
0602 D2D7              ;               Y = trashed
0603 D2D7              ;               P = nvmxdizc
0604 D2D7              ;                   ..000..|
0605 D2D7              ;                          0 if closed OK, 1 if not
0606 D2D7              ;
0607 D2D7              ;==========================================================
0608 D2D7
0609 D2D7              get_input_port Proc 
0610 D2D7                       Import input_port:InputPortRec
0611 D2D7
0612 D2D7 A9 01 80              lda   #$8001                   ; subcall = GetInputPort
0613 D2DA 85 16                 sta   <drvr_stat_code
0614 D2DC
0615 D2DC A9 05 00              lda   #drvr_status             ; make a status call
0616 D2DF 85 02                 sta   <drvr_call_num
0617 D2E1
0618 D2E1 A2 D4 B2              ldx   #input_port              ; status list = InputPortRec
0619 D2E4 A0 00 00              ldy   #^input_port
0620 D2E7
0621 D2E7 A9 11 00              lda   #$0011                   ; sizeof(InputPortRec)
0622 D2EA 82 C9 FF              brl   console_dispatch         ; call the console driver (rts)
0623 D2ED                       EndP 
0624 D2ED
0625 D2ED                       eject 
0626 D2ED              ;==========================================================
0627 D2ED              ;
0628 D2ED              ;  write_num_str
0629 D2ED              ;
0630 D2ED              ;  Write the string specified by A.  This is the index #
0631 D2ED              ;  for a string in the error.msg file.
0632 D2ED              ;
0633 D2ED              ;  Inputs:      A = string # to print
0634 D2ED              ;
0635 D2ED              ;  Outputs:     A = trashed
0636 D2ED              ;               X = trashed
0637 D2ED              ;               Y = trashed
0638 D2ED              ;               P = nvmxdizc
0639 D2ED              ;                   ..000...
0640 D2ED              ;
0641 D2ED              ;
0642 D2ED              ;==========================================================
0643 D2ED
0644 D2ED              write_num_str Proc 
0645 D2ED                       Import get_string
0646 D2ED
0647 D2ED 22 50 D2 01           jsl   get_string
0648 D2F1 80 15                 bra   write_pstring            ; (rts)
0649 D2F3
0650 D2F3                       eject 
0651 D2F3              ;==========================================================
0652 D2F3              ;
0653 D2F3              ;  write_2char
0654 D2F3              ;
0655 D2F3              ;  Write the characters contained in A: lo byte, then high.
0656 D2F3              ;
0657 D2F3              ;  Inputs:      A = 2 ascii chars
0658 D2F3              ;
0659 D2F3              ;  Outputs:     A = trashed
0660 D2F3              ;               X = trashed
0661 D2F3              ;               Y = trashed
0662 D2F3              ;               P = nvmxdizc
0663 D2F3              ;                   ..000...
0664 D2F3              ;
0665 D2F3              ;  Uses:        init_temp_1
0666 D2F3              ;
0667 D2F3              ;==========================================================
0668 D2F3                       Entry write_2char
0669 D2F3              write_2char  
0670 D2F3 48                    pha   
0671 D2F4 20 F9 D2              jsr   write_char
0672 D2F7 68                    pla   
0673 D2F8 EB                    xba   
0674 D2F9              ;	bra	write_char	; (rts)
0675 D2F9                                                      ;fall into write_char
0676 D2F9
0677 D2F9                       eject 
0678 D2F9              ;==========================================================
0679 D2F9              ;
0680 D2F9              ;  write_char
0681 D2F9              ;
0682 D2F9              ;  Write the character in the low byte of A.
0683 D2F9              ;
0684 D2F9              ;  Inputs:      A = ascii to write
0685 D2F9              ;
0686 D2F9              ;  Outputs:     A = trashed
0687 D2F9              ;               X = trashed
0688 D2F9              ;               Y = trashed
0689 D2F9              ;               P = nvmxdizc
0690 D2F9              ;                   ..000...
0691 D2F9              ;
0692 D2F9              ;  Uses:        init_temp_1
0693 D2F9              ;
0694 D2F9              ;==========================================================
0695 D2F9                       Entry write_char
0696 D2F9              write_char  
0697 D2F9 29 FF 00              and   #$00FF                   ; make p string
0698 D2FC EB                    xba   
0699 D2FD 1A                    inc   a
0700 D2FE 8F B6 B2 00           sta   >std_buffer
0701 D302 A2 B6 B2              ldx   #<std_buffer
0702 D305 A0 00 00              ldy   #^std_buffer
0703 D308              ;	brl	write_pstring
0704 D308                                                      ;fall into write_pstring
0705 D308
0706 D308                       eject 
0707 D308              ;==========================================================
0708 D308              ;
0709 D308              ;  write_pstring
0710 D308              ;  write_gstring
0711 D308              ;
0712 D308              ;  Write the specified string.  In the write_gstring call,
0713 D308              ;  there is a special hack which skips over the first
0714 D308              ;  character of the string, this eliminates the separator
0715 D308              ;  which is $80 or ':' or other nastiness.
0716 D308              ;
0717 D308              ;  Inputs:      X,Y = pointer to a (p- or g-) string
0718 D308              ;
0719 D308              ;  Outputs:     A = trashed
0720 D308              ;               X = trashed
0721 D308              ;               Y = trashed
0722 D308              ;               P = nvmxdizc
0723 D308              ;                   ..000...
0724 D308              ;
0725 D308              ;  Uses: init_temp_1
0726 D308              ;
0727 D308              ;==========================================================
0728 D308                       Entry write_pstring
0729 D308              write_pstring  
0730 D308                       with my_direct_page
0731 D308
0732 D308 86 AA                 stx   <init_temp_1
0733 D30A 84 AC                 sty   <init_temp_1+2
0734 D30C
0735 D30C E8                    inx                            ; make ptr to text
0736 D30D D0 01                 bne   write_pstr_1
0737 D30F C8                    iny   
0738 D310              write_pstr_1  
0739 D310
0740 D310 A7 AA                 lda   [<init_temp_1]           ; get length
0741 D312 29 FF 00              and   #$00FF
0742 D315
0743 D315 80 0F                 bra   common_write
0744 D317
0745 D317                       entry write_gstring
0746 D317              write_gstring  
0747 D317 86 AA                 stx   <init_temp_1
0748 D319 84 AC                 sty   <init_temp_1+2
0749 D31B
0750 D31B 8A                    txa                            ; add 3 (skip length and separator)
0751 D31C 18                    clc   
0752 D31D 69 03 00              adc   #3
0753 D320 AA                    tax   
0754 D321 90 01                 bcc   write_gstr_1
0755 D323 C8                    iny   
0756 D324              write_gstr_1  
0757 D324
0758 D324 A7 AA                 lda   [<init_temp_1]           ; get length
0759 D326
0760 D326              ;  common part of write_n_string : length in A, ptr in X,Y
0761 D326                       entry common_write
0762 D326              common_write  
0763 D326 85 08                 sta   <drvr_req_cnt
0764 D328 64 0A                 stz   <drvr_req_cnt+2
0765 D32A 86 04                 stx   <drvr_buf_ptr
0766 D32C 84 06                 sty   <drvr_buf_ptr+2
0767 D32E AD 0A D0              lda   |cons_dev_num
0768 D331 85 00                 sta   <drvr_dev_num
0769 D333 A9 03 00              lda   #drvr_write
0770 D336 85 02                 sta   <drvr_call_num
0771 D338 64 14                 stz   <drvr_blk_size
0772 D33A 22 18 D4 00           jsl   call_dispatch
0773 D33E 60                    rts   
0774 D33F                       EndP 
0775 D33F
0776 D33F                       eject 
0777 D33F              ;==========================================================
0778 D33F              ;
0779 D33F              ;  find_console
0780 D33F              ;
0781 D33F              ;  Call the get_dnum routine in the Device Dispatcher to
0782 D33F              ;  get the device # of the device named 'CONSOLE'.
0783 D33F              ;
0784 D33F              ;  The p-string 'CONSOLE' is contained in the Device Dispatcher
0785 D33F              ;  itself since the Init Mgr has no room left in its $00/B200
0786 D33F              ;  space for the string and the string can't live in LC Bank1 space.
0787 D33F              ;
0788 D33F              ;  Outputs:     cons_dev_num = device #  
0789 D33F              ;               A = error # if c=1, else trashed
0790 D33F              ;               X = trashed
0791 D33F              ;               Y = trashed
0792 D33F              ;               P = nvmxdizc
0793 D33F              ;                   ..000..|
0794 D33F              ;                          0 = ok, 1 = device not found
0795 D33F              ;
0796 D33F              ;==========================================================
0797 D33F
0798 D33F              find_console Proc 
0799 D33F                       Import console_string,get_dnum
0800 D33F
0801 D33F F4 E0 00              pea   get_dnum>>16             ;address of get_dnum routine
0802 D342 F4 71 FB              pea   get_dnum
0803 D345 F4 00 00              pea   $0000                    ;lc bank 0
0804 D348 A2 52 FC              ldx   #console_string          ;address of p-string "CONSOLE"
0805 D34B A0 E0 00              ldy   #console_string>>16
0806 D34E 22 87 B1 00           jsl   >lc_dispatcher
0807 D352 8D 0A D0              sta   |cons_dev_num            ;device #
0808 D355 60                    rts   
0809 D356                       EndP 
0810 D356
0811 D356                       eject 
0812 D356              ;==========================================================
0813 D356              ;
0814 D356              ;  restore_state
0815 D356              ;
0816 D356              ;  Rolls data from vid_state (see above) back into the
0817 D356              ;  various soft switches.
0818 D356              ;
0819 D356              ;  Inputs:      vid_state = (as shown above)
0820 D356              ;
0821 D356              ;  Outputs:     A = trashed
0822 D356              ;               X = trashed
0823 D356              ;               Y = trashed
0824 D356              ;               P = nvmxdizc
0825 D356              ;                   ..000...
0826 D356              ;
0827 D356              ;==========================================================
0828 D356
0829 D356              restore_state Proc 
0830 D356                       with my_direct_page
0831 D356
0832 D356 E2 30                 sep   #$30
0833 D358                       longa off
0834 D358                       longi off
0835 D358
0836 D358 AD 0C D0              lda   |vid_state               ; put where easier to get at
0837 D35B 85 AA                 sta   <init_temp_1
0838 D35D
0839 D35D AD 29 C0              lda   |new_video               ; just touch bit 7 here
0840 D360 2A                    rol   a
0841 D361 66 AA                 ror   <init_temp_1
0842 D363 6A                    ror   a
0843 D364 8D 29 C0              sta   |new_video
0844 D367
0845 D367 A0 00                 ldy   #0                       ; easy source of zeros
0846 D369
0847 D369 66 AA                 ror   <init_temp_1
0848 D36B 98                    tya   
0849 D36C 2A                    rol   a                        ; setup 0 or 1 index
0850 D36D AA                    tax   
0851 D36E 9D 0C C0              sta   |clr80vid,X              ; to hit paired soft switches
0852 D371
0853 D371 66 AA                 ror   <init_temp_1
0854 D373 98                    tya   
0855 D374 2A                    rol   a
0856 D375 AA                    tax   
0857 D376 9D 0E C0              sta   |clraltchar,X
0858 D379
0859 D379 66 AA                 ror   <init_temp_1
0860 D37B 98                    tya   
0861 D37C 2A                    rol   a
0862 D37D AA                    tax   
0863 D37E 9D 54 C0              sta   |txtpage1,X
0864 D381
0865 D381 66 AA                 ror   <init_temp_1
0866 D383 98                    tya   
0867 D384 2A                    rol   a
0868 D385 AA                    tax   
0869 D386 9D 50 C0              sta   |txtclr,X
0870 D389
0871 D389 66 AA                 ror   <init_temp_1
0872 D38B 98                    tya   
0873 D38C 2A                    rol   a
0874 D38D AA                    tax   
0875 D38E 9D 00 C0              sta   |clr80col,X
0876 D391
0877 D391 C2 30                 rep   #$30
0878 D393                       longa on
0879 D393                       longi on
0880 D393
0881 D393 60                    rts   
0882 D394                       EndP 
0883 D394
0884 D394                       eject 
0885 D394              ;==========================================================
0886 D394              ;
0887 D394              ;  save_state
0888 D394              ;
0889 D394              ;  Preserves the state of the video modes.  Everything
0890 D394              ;  pertaining to a text-based screen is saved.  The status
0891 D394              ;  bits are rolled into the byte 'vid_state' as follows:
0892 D394              ;   ___ ___ ___ ___ ___ ___ ___ ___
0893 D394              ;  |   |   |   |   |   |   |   |   |
0894 D394              ;  | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0895 D394              ;  |___|___|___|___|___|___|___|___|
0896 D394              ;    |   |   |   |   |   |   |   |__new video
0897 D394              ;    |   |   |   |   |   |   |______80 vid
0898 D394              ;    |   |   |   |   |   |__________alt char
0899 D394              ;    |   |   |   |   |______________page 2
0900 D394              ;    |   |   |   |__________________text mode
0901 D394              ;    |   |   |______________________80 col
0902 D394              ;    |___|__________________________(always 0)
0903 D394              ;
0904 D394              ;  Then we put everything the way _we_ want it!
0905 D394              ;
0906 D394              ;  Outputs:     vid_state = (as shown above)
0907 D394              ;               A = trashed
0908 D394              ;               X = trashed
0909 D394              ;               Y = trashed
0910 D394              ;               P = nvmxdizc
0911 D394              ;                   ..000...
0912 D394              ;
0913 D394              ;==========================================================
0914 D394
0915 D394              save_state Proc 
0916 D394                       with my_direct_page
0917 D394
0918 D394 E2 30                 sep   #$30                     ; 8 bit mode for all this
0919 D396                       longa off
0920 D396                       longi off
0921 D396
0922 D396 64 AA                 stz   <init_temp_1
0923 D398
0924 D398 AD 18 C0              lda   |rd80col                 ; get info 1 bit at a time
0925 D39B 2A                    rol   a
0926 D39C 26 AA                 rol   <init_temp_1
0927 D39E
0928 D39E AD 1A C0              lda   |rdtext
0929 D3A1 2A                    rol   a
0930 D3A2 26 AA                 rol   <init_temp_1
0931 D3A4
0932 D3A4 AD 1C C0              lda   |rdpage2
0933 D3A7 2A                    rol   a
0934 D3A8 26 AA                 rol   <init_temp_1
0935 D3AA
0936 D3AA AD 1E C0              lda   |altcharset
0937 D3AD 2A                    rol   a
0938 D3AE 26 AA                 rol   <init_temp_1
0939 D3B0
0940 D3B0 AD 1F C0              lda   |rd80vid
0941 D3B3 2A                    rol   a
0942 D3B4 26 AA                 rol   <init_temp_1
0943 D3B6
0944 D3B6 AD 29 C0              lda   |new_video
0945 D3B9 2A                    rol   a
0946 D3BA 26 AA                 rol   <init_temp_1
0947 D3BC
0948 D3BC A9 36                 lda   #$36                     		; 80col tx p1 altch 80vid oldvideo
0949 D3BE 8D 0C D0              sta   |vid_state
0950 D3C1
0951 D3C1 C2 30                 rep   #$30
0952 D3C3                       longa on
0953 D3C3                       longi on
0954 D3C3
0955 D3C3 D4 AA                 pei   <init_temp_1
0956 D3C5 20 56 D3              jsr   restore_state            	; now make screen for ME
0957 D3C8 68                    pla   
0958 D3C9 8D 0C D0              sta   |vid_state
0959 D3CC 60                    rts   
0960 D3CD                       EndP 
0961 D3CD
0962 D3CD                       eject 
0963 D3CD              ;==========================================================
0964 D3CD              ;
0965 D3CD              ;  save_cons_state
0966 D3CD              ;
0967 D3CD              ;  Preserves the state of the console driver- whether it
0968 D3CD              ;  was open ; and what wait & read modes were set.  Then it
0969 D3CD              ;  is opened (if necessary) and set for raw read + wait mode.
0970 D3CD              ;  The original state is stored in console_state in the
0971 D3CD              ;  following format:
0972 D3CD              ;   ______ ___ ___ ___ ___ ___ ___ ___ ___
0973 D3CD              ;  |      |   |   |   |   |   |   |   |   |
0974 D3CD              ;  | 15-8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
0975 D3CD              ;  |______|___|___|___|___|___|___|___|___|
0976 D3CD              ;      |    |   |   |   |   |   |   |   |__console open
0977 D3CD              ;      |    |   |   |   |   |   |   |______no_wait_mode
0978 D3CD              ;      |    |   |   |   |   |   |__________raw input mode
0979 D3CD              ;      |____|___|___|___|___|______________always 0
0980 D3CD              ;
0981 D3CD              ;  Then we put everything the way _we_ want it!
0982 D3CD              ;
0983 D3CD              ;  Outputs:     console_state = (as shown above)
0984 D3CD              ;               A = trashed
0985 D3CD              ;               X = trashed
0986 D3CD              ;               Y = trashed
0987 D3CD              ;               P = nvmxdizc
0988 D3CD              ;                   ..000...
0989 D3CD              ;
0990 D3CD              ;==========================================================
0991 D3CD
0992 D3CD              save_cons_state Proc 
0993 D3CD                       Import dflt_input_port,term_list,term_list_len:equ
0994 D3CD                       Import call_alloc,call_deref
0995 D3CD
0996 D3CD                       with my_direct_page
0997 D3CD
0998 D3CD A9 00 00              lda   #0                       ; get driver status
0999 D3D0 20 9F D2              jsr   call_status
1000 D3D3 AF B6 B2 00           lda   >std_buffer
1001 D3D7 29 01 00              and   #1
1002 D3DA 85 AA                 sta   <init_temp_1
1003 D3DC D0 03                 bne   sk_open_con              ; already open
1004 D3DE
1005 D3DE 20 90 D2              jsr   call_open
1006 D3E1
1007 D3E1              sk_open_con  
1008 D3E1 A9 02 00              lda   #2                       ; get wait mode
1009 D3E4 20 9F D2              jsr   call_status
1010 D3E7 AF B6 B2 00           lda   >std_buffer
1011 D3EB 2A                    rol   a
1012 D3EC 26 AA                 rol   <init_temp_1
1013 D3EE A9 05 80              lda   #$8005                   ; get read mode
1014 D3F1 20 9F D2              jsr   call_status
1015 D3F4 AF B6 B2 00           lda   >std_buffer
1016 D3F8 2A                    rol   a
1017 D3F9
1018 D3F9              ;  create final product and store at >console_state
1019 D3F9
1020 D3F9 A5 AA                 lda   <init_temp_1
1021 D3FB 2A                    rol   a
1022 D3FC 8D 0E D0              sta   |console_state
1023 D3FF
1024 D3FF              ;  buffer off any existing Input Port record, Terminator list, and
1025 D3FF              ;  default string
1026 D3FF
1027 D3FF A9 11 00              lda   #17                      ;17 bytes for Input Port record
1028 D402 22 00 D4 00           jsl   call_alloc
1029 D406 8E 24 D0              stx   save_in_port
1030 D409 8C 26 D0              sty   save_in_port+2
1031 D40C 22 08 D4 00           jsl   call_deref
1032 D410                                                      ;leave pointer in X and Y
1033 D410 A9 01 80              lda   #$8001                   ;GetInputPort
1034 D413 85 16                 sta   <drvr_stat_code
1035 D415 A9 05 00              lda   #drvr_status
1036 D418 85 02                 sta   <drvr_call_num
1037 D41A A9 11 00              lda   #17                      ;requestCount
1038 D41D 20 B6 D2              jsr   console_dispatch         ;make the call
1039 D420
1040 D420 A9 02 02              lda   #514                     ;514 bytes for maximum terminator list
1041 D423 22 00 D4 00           jsl   call_alloc
1042 D427 8E 28 D0              stx   save_term_list
1043 D42A 8C 2A D0              sty   save_term_list+2
1044 D42D 22 08 D4 00           jsl   call_deref
1045 D431                                                      ;leave pointer in X and Y
1046 D431 A9 02 80              lda   #$8002                   ;GetTerminators
1047 D434 85 16                 sta   <drvr_stat_code
1048 D436 A9 05 00              lda   #drvr_status
1049 D439 85 02                 sta   <drvr_call_num
1050 D43B A9 02 02              lda   #514                     ;requestCount
1051 D43E 20 B6 D2              jsr   console_dispatch         ;make the call
1052 D441 A5 0C                 lda   <drvr_tran_cnt           ;save the length of the returned record
1053 D443 8D 2C D0              sta   save_list_len
1054 D446
1055 D446 A9 FF 00              lda   #255                     ;255 bytes for default string
1056 D449 22 00 D4 00           jsl   call_alloc
1057 D44D 8E 2E D0              stx   save_dflt_string
1058 D450 8C 30 D0              sty   save_dflt_string+2
1059 D453 22 08 D4 00           jsl   call_deref
1060 D457                                                      ;leave pointer in X and Y
1061 D457 A9 06 80              lda   #$8006                   ;GetDefaultString
1062 D45A 85 16                 sta   <drvr_stat_code
1063 D45C A9 05 00              lda   #drvr_status
1064 D45F 85 02                 sta   <drvr_call_num
1065 D461 A9 FF 00              lda   #255                     ;requestCount
1066 D464 20 B6 D2              jsr   console_dispatch
1067 D467 A5 0C                 lda   <drvr_tran_cnt           ;save the length of the string
1068 D469 8D 32 D0              sta   dflt_string_len
1069 D46C
1070 D46C              ;  now set:  wait mode, raw read mode
1071 D46C
1072 D46C A9 00 00              lda   #0
1073 D46F 8F B6 B2 00           sta   >std_buffer
1074 D473 A9 04 00              lda   #4                       ; set wait mode
1075 D476 20 A6 D2              jsr   call_control
1076 D479 A9 00 80              lda   #$8000
1077 D47C 8F B6 B2 00           sta   >std_buffer
1078 D480 A9 03 80              lda   #$8003                   ; set raw read mode
1079 D483 20 A6 D2              jsr   call_control
1080 D486
1081 D486              ; now we send the terminator list to the console driver
1082 D486
1083 D486 A9 01 80              lda   #$8001                   ; SetTerminators
1084 D489 85 16                 sta   <drvr_ctrl_code
1085 D48B A9 06 00              lda   #drvr_control            ; make a control call
1086 D48E 85 02                 sta   <drvr_call_num
1087 D490
1088 D490 A9 0E 00              lda   #term_list_len
1089 D493 A2 C1 B2              ldx   #<term_list
1090 D496 A0 00 00              ldy   #^term_list
1091 D499 20 B6 D2              jsr   console_dispatch         ; call the console driver
1092 D49C
1093 D49C A9 00 80              lda   #$8000                   ; SetInputPort
1094 D49F 85 16                 sta   <drvr_ctrl_code
1095 D4A1 A9 06 00              lda   #drvr_control            ; make a control call
1096 D4A4 85 02                 sta   <drvr_call_num
1097 D4A6
1098 D4A6 A9 05 00              lda   #5                       ; only modify first 5 bytes
1099 D4A9 A2 CF B2              ldx   #<dflt_input_port
1100 D4AC A0 00 00              ldy   #^dflt_input_port
1101 D4AF 20 B6 D2              jsr   console_dispatch         ; call the console driver
1102 D4B2
1103 D4B2 60                    rts   
1104 D4B3                       EndP 
1105 D4B3
1106 D4B3                       eject 
1107 D4B3              ;==========================================================
1108 D4B3              ;
1109 D4B3              ;  restore_console
1110 D4B3              ;
1111 D4B3              ;  Sets the console driver back into its original state.
1112 D4B3              ;
1113 D4B3              ;  Inputs:      console_state = (as shown above)
1114 D4B3              ;
1115 D4B3              ;  Outputs:     A = trashed
1116 D4B3              ;               X = trashed
1117 D4B3              ;               Y = trashed
1118 D4B3              ;               P = nvmxdizc
1119 D4B3              ;                   ..000...
1120 D4B3              ;
1121 D4B3              ;==========================================================
1122 D4B3
1123 D4B3              restore_console Proc 
1124 D4B3                       Import call_deref,call_release
1125 D4B3
1126 D4B3                       with my_direct_page
1127 D4B3
1128 D4B3              ; restore the original Input Port, Terminator List, and default string
1129 D4B3
1130 D4B3 AE 2E D0              ldx   save_dflt_string
1131 D4B6 AC 30 D0              ldy   save_dflt_string+2
1132 D4B9 22 08 D4 00           jsl   call_deref
1133 D4BD                                                      ;leave pointer in X and Y
1134 D4BD A9 04 80              lda   #$8004                   ; SetDefaultString
1135 D4C0 85 16                 sta   <drvr_ctrl_code
1136 D4C2 A9 06 00              lda   #drvr_control
1137 D4C5 85 02                 sta   <drvr_call_num
1138 D4C7 AD 32 D0              lda   dflt_string_len          ; requestCount
1139 D4CA 20 B6 D2              jsr   console_dispatch
1140 D4CD AE 2E D0              ldx   save_dflt_string         ; deallocate buffer
1141 D4D0 AC 30 D0              ldy   save_dflt_string+2
1142 D4D3 22 10 D4 00           jsl   call_release
1143 D4D7
1144 D4D7 AE 28 D0              ldx   save_term_list
1145 D4DA AC 2A D0              ldy   save_term_list+2
1146 D4DD 22 08 D4 00           jsl   call_deref
1147 D4E1                                                      ;leave pointer in X and Y
1148 D4E1 A9 01 80              lda   #$8001                   ; SetTerminators
1149 D4E4 85 16                 sta   <drvr_ctrl_code
1150 D4E6 A9 06 00              lda   #drvr_control
1151 D4E9 85 02                 sta   <drvr_call_num
1152 D4EB AD 2C D0              lda   save_list_len            ; requestCount
1153 D4EE 20 B6 D2              jsr   console_dispatch
1154 D4F1 AE 28 D0              ldx   save_term_list           ; deallocate buffer
1155 D4F4 AC 2A D0              ldy   save_term_list+2
1156 D4F7 22 10 D4 00           jsl   call_release
1157 D4FB
1158 D4FB AE 24 D0              ldx   save_in_port
1159 D4FE AC 26 D0              ldy   save_in_port+2
1160 D501 22 08 D4 00           jsl   call_deref
1161 D505                                                      ;leave pointer in X and Y
1162 D505 A9 00 80              lda   #$8000                   ; SetInputPort
1163 D508 85 16                 sta   <drvr_ctrl_code
1164 D50A A9 06 00              lda   #drvr_control
1165 D50D 85 02                 sta   <drvr_call_num
1166 D50F A9 11 00              lda   #17                      ; requestCount
1167 D512 20 B6 D2              jsr   console_dispatch
1168 D515 AE 24 D0              ldx   save_in_port             ; deallocate buffer
1169 D518 AC 26 D0              ldy   save_in_port+2
1170 D51B 22 10 D4 00           jsl   call_release
1171 D51F
1172 D51F              ; restore the other settings
1173 D51F
1174 D51F AD 0E D0              lda   |console_state
1175 D522 85 AA                 sta   <init_temp_1
1176 D524
1177 D524 A9 00 00              lda   #0
1178 D527 66 AA                 ror   <init_temp_1
1179 D529 6A                    ror   a
1180 D52A 8F B6 B2 00           sta   >std_buffer
1181 D52E A9 03 80              lda   #$8003                   ; set read mode
1182 D531 20 A6 D2              jsr   call_control
1183 D534
1184 D534 A9 00 00              lda   #0
1185 D537 66 AA                 ror   <init_temp_1
1186 D539 6A                    ror   a
1187 D53A 8F B6 B2 00           sta   >std_buffer
1188 D53E A9 04 00              lda   #0004                    ; set wait/no-wait mode
1189 D541 20 A6 D2              jsr   call_control
1190 D544
1191 D544 A5 AA                 lda   <init_temp_1             ; was it open?
1192 D546 D0 03                 bne   sk_close_cons            ; yes, don't close
1193 D548 20 C8 D2              jsr   call_close
1194 D54B              sk_close_cons  
1195 D54B 60                    rts   
1196 D54C                       EndP 
1197 D54C
1198 D54C                       eject 
1199 D54C              ;==========================================================
1200 D54C              ;
1201 D54C              ;  save_tx_screen
1202 D54C              ;
1203 D54C              ;  Prepare the text screen for use:
1204 D54C              ;
1205 D54C              ;  (1)  Push viewport (sets full size)
1206 D54C              ;  (2)  Save entire screen
1207 D54C              ;  (3)  If video mode changed, clear entire screen
1208 D54C              ;
1209 D54C              ;  Outputs:     port_save = saved screen image
1210 D54C              ;               A = trashed
1211 D54C              ;               X = trashed
1212 D54C              ;               Y = trashed
1213 D54C              ;               P = nvmxdizc
1214 D54C              ;                   ..000...
1215 D54C              ;
1216 D54C              ;==========================================================
1217 D54C
1218 D54C              save_tx_screen  Proc 
1219 D54C                       Import gsos_id
1220 D54C                       with my_direct_page
1221 D54C
1222 D54C A9 01 00              lda   #$01                     		; push vp
1223 D54F 20 F9 D2              jsr   write_char
1224 D552
1225 D552              ;  get memory for a port buffer
1226 D552
1227 D552 A9 00 00              lda   #0
1228 D555 48                    pha                            ; returns long
1229 D556 48                    pha   
1230 D557 48                    pha                            ; size 1920 + 2
1231 D558 F4 82 07              pea   1920+2
1232 D55B AF E2 B9 00           lda   >gsos_id                 ; use Mike's memory ID
1233 D55F 48                    pha   
1234 D560 F4 00 C0              pea   $C000                    ; locked
1235 D563 48                    pha                            ; bank doesn't matter
1236 D564 48                    pha   
1237 D565 A2 02 09              ldx   #$0902                   ; NewHandle
1238 D568 22 00 00 E1           jsl   $E10000
1239 D56C
1240 D56C 68                    pla   
1241 D56D 85 AA                 sta   <init_temp_1
1242 D56F 68                    pla   
1243 D570 85 AC                 sta   <init_temp_1+2
1244 D572
1245 D572 A7 AA                 lda   [<init_temp_1]           ; deref the handle
1246 D574 8D 1A D0              sta   |scr_save_buf
1247 D577 85 04                 sta   <drvr_slist_ptr
1248 D579 A0 02 00              ldy   #2
1249 D57C B7 AA                 lda   [<init_temp_1],y
1250 D57E 8D 1C D0              sta   |scr_save_buf+2
1251 D581 85 06                 sta   <drvr_slist_ptr+2
1252 D583
1253 D583              ; save the port
1254 D583
1255 D583 A9 03 80              lda   #$8003                   ; save text port
1256 D586 85 16                 sta   <drvr_stat_code
1257 D588 A9 05 00              lda   #drvr_status
1258 D58B 85 02                 sta   <drvr_call_num
1259 D58D AD 0A D0              lda   |cons_dev_num
1260 D590 85 00                 sta   <drvr_dev_num
1261 D592 A9 82 07              lda   #1920+2
1262 D595 85 08                 sta   <drvr_req_cnt
1263 D597 64 0A                 stz   <drvr_req_cnt+2
1264 D599 22 18 D4 00           jsl   >call_dispatch
1265 D59D
1266 D59D              ; clear screen if mode changed
1267 D59D
1268 D59D AD 0C D0              lda   |vid_state
1269 D5A0 29 17 00              and   #$0017                   ; want: text on, altchar on,
1270 D5A3 C9 16 00              cmp   #$0016                   ;       80vid on, new vid off
1271 D5A6 F0 06                 beq   sk_clr_scr
1272 D5A8
1273 D5A8 A9 0C 00              lda   #$0C                     ; clear that puppy
1274 D5AB 20 F9 D2              jsr   write_char
1275 D5AE              sk_clr_scr  
1276 D5AE
1277 D5AE 60                    rts   
1278 D5AF                       EndP 
1279 D5AF
1280 D5AF                       eject 
1281 D5AF              ;==========================================================
1282 D5AF              ;
1283 D5AF              ;  restore_tx_scr
1284 D5AF              ;
1285 D5AF              ;  Restore the text screen to its original state
1286 D5AF              ;
1287 D5AF              ;  Inputs:      port_save = saved screen image
1288 D5AF              ;
1289 D5AF              ;  Outputs:     A = trashed
1290 D5AF              ;               X = trashed
1291 D5AF              ;               Y = trashed
1292 D5AF              ;               P = nvmxdizc
1293 D5AF              ;                   ..000...
1294 D5AF              ;
1295 D5AF              ;==========================================================
1296 D5AF
1297 D5AF              restore_tx_scr Proc 
1298 D5AF A9 04 00              lda   #$04                     ; 'pop port'
1299 D5B2 20 F9 D2              jsr   write_char               ; (to the prev, which is full scr)
1300 D5B5
1301 D5B5 A9 02 80              lda   #$8002                   ; restore text port
1302 D5B8 85 16                 sta   <drvr_ctrl_code
1303 D5BA A9 06 00              lda   #drvr_control
1304 D5BD 85 02                 sta   <drvr_call_num
1305 D5BF AD 0A D0              lda   |cons_dev_num
1306 D5C2 85 00                 sta   <drvr_dev_num
1307 D5C4 AD 1A D0              lda   |scr_save_buf
1308 D5C7 85 04                 sta   <drvr_slist_ptr
1309 D5C9 AD 1C D0              lda   |scr_save_buf+2
1310 D5CC 85 06                 sta   <drvr_slist_ptr+2
1311 D5CE A9 82 07              lda   #1920+2
1312 D5D1 85 08                 sta   <drvr_req_cnt
1313 D5D3 64 0A                 stz   <drvr_req_cnt+2
1314 D5D5 22 18 D4 00           jsl   >call_dispatch
1315 D5D9
1316 D5D9              ;  toss out the memory
1317 D5D9
1318 D5D9 48                    pha   
1319 D5DA 48                    pha   
1320 D5DB AD 1C D0              lda   |scr_save_buf+2
1321 D5DE 48                    pha   
1322 D5DF AD 1A D0              lda   |scr_save_buf
1323 D5E2 48                    pha   
1324 D5E3 A2 02 1A              ldx   #$1A02                   ; findHandle
1325 D5E6 22 00 00 E1           jsl   $E10000
1326 D5EA
1327 D5EA A2 02 10              ldx   #$1002                   ; disposeHandle
1328 D5ED 22 00 00 E1           jsl   $E10000
1329 D5F1
1330 D5F1              ; and restore to the original port
1331 D5F1
1332 D5F1 A9 04 00              lda   #$04                     ; 'pop port'
1333 D5F4 82 02 FD              brl   write_char               ; (rts)
1334 D5F7                       EndP 
1335 D5F7
1336 D5F7                       eject 
1337 D5F7              ;==========================================================
1338 D5F7              ;
1339 D5F7              ;  txTextBox2
1340 D5F7              ;
1341 D5F7              ;  Prints the supplied string within the message box in
1342 D5F7              ;  the text dialog.
1343 D5F7              ;
1344 D5F7              ;  Inputs:      X, Y = pointer to pascal string to print
1345 D5F7              ;
1346 D5F7              ;  Outputs:     A = trashed
1347 D5F7              ;               X = trashed
1348 D5F7              ;               Y = trashed
1349 D5F7              ;               P = nvmxdizc
1350 D5F7              ;                   ..000...
1351 D5F7              ;
1352 D5F7              ;  Variable usage:
1353 D5F7              ;               strPtr = supplied pointer to the string
1354 D5F7              ;               strLen = length of string
1355 D5F7              ;
1356 D5F7              ;==========================================================
1357 D5F7
1358 D5F7              txTextBox2 Proc 
1359 D5F7                       with my_direct_page
1360 D5F7
1361 D5F7              strPtr   equ   init_temp_3
1362 D5F7              strLen   equ   init_temp_4
1363 D5F7              window_width equ   47                   ;width of the message box
1364 D5F7
1365 D5F7 86 B2                 stx   <strPtr
1366 D5F9 84 B4                 sty   <strPtr+2
1367 D5FB A7 B2                 lda   [<strPtr]                ; get the string length
1368 D5FD 29 FF 00              and   #$00ff
1369 D600 85 B6                 sta   <strLen
1370 D602 E6 B2                 inc   <strPtr                  ; bump pointer to actual text
1371 D604 D0 02                 bne   set_new_port
1372 D606 E6 B4                 inc   <strPtr+2
1373 D608              set_new_port  
1374 D608
1375 D608              ; Set a new text port to the dimensions of the message box
1376 D608
1377 D608 A9 01 02              lda   #saveTxtPort+(setTxtPortSize<<8)
1378 D60B 20 F3 D2              jsr   write_2char
1379 D60E A9 30 2F              lda   #(16+32)+((15+32)<<8)    ; 16, 15
1380 D611 20 F3 D2              jsr   write_2char
1381 D614 A9 5E 32              lda   #(62+32)+((18+32)<<8)    ; 62, 18
1382 D617 20 F3 D2              jsr   write_2char
1383 D61A
1384 D61A A9 0C 00              lda   #clearScreen             ; clear the port
1385 D61D 20 F9 D2              jsr   write_char
1386 D620
1387 D620              while_loop                              ; while (strlen<window_width)
1388 D620 A5 B6                 lda   <strLen                  ; get the string length
1389 D622 C9 30 00              cmp   #window_width+1          ; less than the width of the window?
1390 D625 90 36                 bcc   end_while                ; yes, just display the string
1391 D627
1392 D627 A0 2E 00              ldy   #window_width-1          ; start search at window_width into string
1393 D62A E2 20                 sep   #$20                     ; 8-bit accumulator
1394 D62C                       longa off
1395 D62C A9 20                 lda   #' '                     ; search for a space
1396 D62E              @search   
1397 D62E D7 B2                 cmp   [strPtr],y               ; is there a space there?
1398 D630 F0 06                 beq   @space_found             ; yes...
1399 D632 88                    dey                            ; else step back one character
1400 D633 D0 F9                 bne   @search                  ; and keep searching
1401 D635 A0 2E 00              ldy   #window_width-1          ; if no space found, just fill the line
1402 D638
1403 D638              @space_found  
1404 D638 5A                    phy                            ; save position of space
1405 D639 C2 20                 rep   #$20                     ; back to 16-bit accumulator
1406 D63B                       longa on
1407 D63B A6 B2                 ldx   <strPtr                  ; get the string pointer into X & Y
1408 D63D A4 B4                 ldy   <strPtr+2
1409 D63F A3 01                 lda   1,s                      ; get the length
1410 D641 38                    sec                            ; (+1 to skip the space)
1411 D642 65 B2                 adc   <strPtr                  ; set pointer to remainder of string
1412 D644 85 B2                 sta   <strPtr
1413 D646 90 02                 bcc   @1
1414 D648 E6 B4                 inc   <strPtr+2
1415 D64A              @1        
1416 D64A A5 B6                 lda   <strLen                  ; get original length
1417 D64C 18                    clc                            ; (-1 to skip the space)
1418 D64D E3 01                 sbc   1,s                      ; calculate remaining length
1419 D64F 85 B6                 sta   <strLen
1420 D651
1421 D651 68                    pla                            ; retrieve length of string segment
1422 D652 20 26 D3              jsr   common_write             ; go write the string
1423 D655
1424 D655 A9 0D 00              lda   #carriageReturn          ; move to next line
1425 D658 20 F9 D2              jsr   write_char
1426 D65B 80 C3                 bra   while_loop               ; go back and do it again
1427 D65D
1428 D65D              end_while  
1429 D65D A5 B6                 lda   <strLen                  ; get the remaining string length
1430 D65F F0 07                 beq   done                     ; if 0, we're done
1431 D661 A6 B2                 ldx   <strPtr                  ; get the string pointer
1432 D663 A4 B4                 ldy   <strPtr+2
1433 D665 20 26 D3              jsr   common_write             ; write the string
1434 D668              done      
1435 D668 A9 04 00              lda   #popTxtPort              ; restore the original text port
1436 D66B 82 8B FC              brl   write_char               ; (rts)
1437 D66E
1438 D66E                       EndP 
1439 D66E
1440 D66E                       eject 
1441 D66E              ;==========================================================
1442 D66E              ;
1443 D66E              ;  draw_top_select
1444 D66E              ;
1445 D66E              ;  Any time top_bar_pos is changed, call this routine to
1446 D66E              ;  draw the 'File System' vs. 'Format' selector bar.
1447 D66E              ;
1448 D66E              ;  Inputs:      top_bar_pos = -1 for FS, 0 for niether, 1 for FMT
1449 D66E              ;
1450 D66E              ;  Outputs:     A = trashed
1451 D66E              ;               X = trashed
1452 D66E              ;               Y = trashed
1453 D66E              ;               P = nvmxdizc
1454 D66E              ;                   ..000...
1455 D66E              ;
1456 D66E              ;==========================================================
1457 D66E
1458 D66E              draw_top_select Proc 
1459 D66E                       with my_direct_page
1460 D66E
1461 D66E A9 1E 00 20           _gotoxy 5,6
1462 D67A A9 0F 00              lda   #inverse                 ; inverse text control code
1463 D67D 48                    pha   
1464 D67E 3A                    dec   a                        ; turn into a normal code
1465 D67F
1466 D67F A6 BA                 ldx   <top_bar_pos             ; get current setting
1467 D681 D0 04                 bne   @which_one               ; something get's inverted!
1468 D683 83 01                 sta   1,s                      ; put 'normal' code on stack
1469 D685 80 05                 bra   draw_top_sel_1           ; then draw the headers
1470 D687
1471 D687              @which_one  
1472 D687 10 03                 bpl   draw_top_sel_1           ; Format should be inverse
1473 D689
1474 D689 83 01                 sta   1,s                      ; else normal 'Format'
1475 D68B 1A                    inc   a                        ; and inverse 'File System'
1476 D68C
1477 D68C              draw_top_sel_1  
1478 D68C 20 F9 D2              jsr   write_char
1479 D68F
1480 D68F A9 1A 00              lda   #26                      ; ' File System '
1481 D692 20 ED D2              jsr   write_num_str
1482 D695
1483 D695 68                    pla   
1484 D696 20 F9 D2              jsr   write_char               ; retrieve correct code for 'Format'
1485 D699
1486 D699 A9 1B 00              lda   #27                      ; htab and print 'Format'
1487 D69C 82 4E FC              brl   write_num_str            ; (rts)
1488 D69F                       EndP 
1489 D69F
1490 D69F                       eject 
1491 D69F              ;==========================================================
1492 D69F              ;
1493 D69F              ;  write_line
1494 D69F              ;
1495 D69F              ;  Draws the line which forms the top & bottom of the
1496 D69F              ;  init window.
1497 D69F              ;
1498 D69F              ;  Inputs:      A = number of characters to write
1499 D69F              ;
1500 D69F              ;  Outputs:     A = trashed
1501 D69F              ;               X = trashed
1502 D69F              ;               Y = trashed
1503 D69F              ;               P = nvmxdizc
1504 D69F              ;                   ..000...
1505 D69F              ;
1506 D69F              ;  Uses: init_temp_2
1507 D69F              ;
1508 D69F              ;  Modified 1-13-89 CAE
1509 D69F              ;
1510 D69F              ;==========================================================
1511 D69F
1512 D69F              write_line Proc 
1513 D69F                       with my_direct_page
1514 D69F
1515 D69F 85 AE                 sta   <init_temp_2             ; save # of chars to write
1516 D6A1
1517 D6A1 A9 1C 00              lda   #$1C                     ; move-right
1518 D6A4 20 F9 D2              jsr   write_char
1519 D6A7
1520 D6A7              write_ln_lp  
1521 D6A7 A9 5F 00              lda   #'_'
1522 D6AA 20 F9 D2              jsr   write_char
1523 D6AD C6 AE                 dec   <init_temp_2
1524 D6AF D0 F6                 bne   write_ln_lp
1525 D6B1
1526 D6B1 A9 1C 00              lda   #$1C                     ; move-right
1527 D6B4 82 42 FC              brl   write_char               ; (rts)
1528 D6B7                       EndP 
1529 D6B7
1530 D6B7                       eject 
1531 D6B7              ;==========================================================
1532 D6B7              ;
1533 D6B7              ;  setup_name
1534 D6B7              ;
1535 D6B7              ;  fills our buffer with the currently entered volume name
1536 D6B7              ;
1537 D6B7              ;==========================================================
1538 D6B7
1539 D6B7
1540 D6B7              setup_name Proc 
1541 D6B7                       Import call_deref,get_string
1542 D6B7
1543 D6B7                       with my_direct_page
1544 D6B7
1545 D6B7 AE 20 D0              ldx   path_vp                  ; deref the VP to our buffer
1546 D6BA AC 22 D0              ldy   path_vp+2
1547 D6BD 22 08 D4 00           jsl   call_deref
1548 D6C1 86 C6                 stx   txt_name_ptr
1549 D6C3 84 C8                 sty   txt_name_ptr+2
1550 D6C5
1551 D6C5 A5 3E                 lda   <path2_ptr               ; make pointer to volume name string
1552 D6C7 05 40                 ora   <path2_ptr+2             ; was a volume name supplied?
1553 D6C9 D0 0F                 bne   @set_it_up               ; yes, use it
1554 D6CB A9 3D 00              lda   #61                      ; get the default volume name string
1555 D6CE 22 50 D2 01           jsl   get_string
1556 D6D2 86 AA                 stx   <init_temp_1
1557 D6D4 84 AC                 sty   <init_temp_1+2
1558 D6D6 A7 AA                 lda   [<init_temp_1]           ; get the length byte
1559 D6D8 80 12                 bra   do_copy
1560 D6DA
1561 D6DA              @set_it_up  
1562 D6DA A5 3E                 lda   <path2_ptr               ; make pointer to volume name string
1563 D6DC 18                    clc   
1564 D6DD 69 02 00              adc   #2                       ; point to separator
1565 D6E0 85 AA                 sta   <init_temp_1
1566 D6E2 A5 40                 lda   <path2_ptr+2             ; high word too
1567 D6E4 69 00 00              adc   #0
1568 D6E7 85 AC                 sta   <init_temp_1+2
1569 D6E9 A7 3E                 lda   [<path2_ptr]             ; get the length word
1570 D6EB 3A                    dec   a                        ; adjust for missing separator
1571 D6EC              do_copy   
1572 D6EC 29 FF 00              and   #$00FF                   ; clear high byte
1573 D6EF C9 21 00              cmp   #33                      ; >32 characters?
1574 D6F2 90 03                 bcc   @ok                      ; no...
1575 D6F4 A9 20 00              lda   #32                      ; else max it out
1576 D6F7              @ok       
1577 D6F7 A8                    tay                            ; into Y for indexing
1578 D6F8 E2 20                 sep   #$20                     ; 8 bit accumulator
1579 D6FA 48                    pha                            ; save length _byte_
1580 D6FB              @loop     
1581 D6FB B7 AA                 lda   [<init_temp_1],y         ; copy name to our buffer
1582 D6FD 97 C6                 sta   [txt_name_ptr],y
1583 D6FF 88                    dey   
1584 D700 D0 F9                 bne   @loop                    ; loop until string is copied
1585 D702 68                    pla                            ; retrieve length _byte_
1586 D703 87 C6                 sta   [txt_name_ptr]           ; store it
1587 D705 C2 20                 rep   #$20                     ; back to 16-bit accumulator
1588 D707              done      
1589 D707 60                    rts   
1590 D708                       endp 
1591 D708
1592 D708                       eject 
1593 D708              ;==========================================================
1594 D708              ;
1595 D708              ;  draw_tx_wind
1596 D708              ;
1597 D708              ;  (1)  Push port
1598 D708              ;  (2)  Set to border port
1599 D708              ;  (3)  Draw border
1600 D708              ;  (4)  Draw static stuff (dev name... volume...  press RETURN etc)
1601 D708              ;
1602 D708              ;  Outputs:     A = trashed
1603 D708              ;               X = trashed
1604 D708              ;               Y = trashed
1605 D708              ;               P = nvmxdizc
1606 D708              ;                   ..000...
1607 D708              ;
1608 D708              ;==========================================================
1609 D708
1610 D708              draw_tx_wind Proc 
1611 D708                       Import get_string
1612 D708
1613 D708                       with my_direct_page
1614 D708
1615 D708              ;  set for window
1616 D708
1617 D708 A9 01 02              lda   #$0201                   ; push vp, set vp
1618 D70B 20 F3 D2              jsr   write_2char
1619 D70E A9 2E 22              lda   #$222E                   ; 14, 2
1620 D711 20 F3 D2              jsr   write_2char
1621 D714 A9 61 35              lda   #$3561                   ; 65, 21
1622 D717 20 F3 D2              jsr   write_2char
1623 D71A A9 15 17              lda   #$1715                   ; disable scroll
1624 D71D 20 F3 D2              jsr   write_2char
1625 D720
1626 D720              ; draw window
1627 D720
1628 D720 A9 32 00              lda   #50                      ; width
1629 D723 20 9F D6              jsr   write_line               ; draw top line
1630 D726
1631 D726 A9 13 00              lda   #19                      ; sides counter
1632 D729 85 AE                 sta   <init_temp_2
1633 D72B
1634 D72B              draw_side_lp  
1635 D72B A9 DA 10              lda   #$10DA                   ; side bar, expand spaces
1636 D72E 20 F3 D2              jsr   write_2char
1637 D731 A9 52 DF              lda   #$DF52                   ; 50 spaces, side bar
1638 D734 20 F3 D2              jsr   write_2char
1639 D737
1640 D737 C6 AE                 dec   <init_temp_2
1641 D739 D0 F0                 bne   draw_side_lp
1642 D73B
1643 D73B A9 32 00              lda   #50                      ; width
1644 D73E 20 9F D6              jsr   write_line               ; draw bottom line
1645 D741
1646 D741 A9 1E 00 20           _gotoxy 6,2
1647 D74D
1648 D74D A2 15 00              ldx   #21                      ; get first string for Format call
1649 D750 AD 02 D0              lda   which_call               ; was the call Format or Erase?
1650 D753 F0 03                 beq   its_format               ; it was Format
1651 D755 A2 1D 00              ldx   #29                      ; get first string for Erase call
1652 D758 8A           its_format txa   
1653 D759 20 ED D2              jsr   write_num_str            ; write out the string
1654 D75C
1655 D75C 64 00                 stz   <drvr_dev_num            ; get name from DIB
1656 D75E A9 01 00              lda   #get_dib_ptr
1657 D761 85 02                 sta   <drvr_call_num
1658 D763 A5 36                 lda   <dev_num
1659 D765 85 04                 sta   <drvr_buf_ptr
1660 D767 22 18 D4 00           jsl   call_dispatch
1661 D76B
1662 D76B A5 20                 lda   <drvr_dib_ptr            ; make pointer to name string
1663 D76D 18                    clc   
1664 D76E 69 0E 00              adc   #$0E
1665 D771 AA                    tax   
1666 D772 A5 22                 lda   <drvr_dib_ptr+2
1667 D774 69 00 00              adc   #0
1668 D777 A8                    tay   
1669 D778 20 08 D3              jsr   write_pstring            ; and write the mother
1670 D77B
1671 D77B A9 1E 00 20           _gotoxy 6,4
1672 D787
1673 D787 A9 16 00              lda   #22                      ; 'as volume'
1674 D78A 20 ED D2              jsr   write_num_str
1675 D78D
1676 D78D 2C 4E D2              bit   pb_flags                 ; editable volume name?
1677 D790 30 15                 bmi   @its_a_control           ; yes, its an editLine control
1678 D792 A9 22 00              lda   #'"'                     ; quote the name
1679 D795 20 F9 D2              jsr   write_char
1680 D798 A6 C6                 ldx   <txt_name_ptr            ; write volume name
1681 D79A A4 C8                 ldy   <txt_name_ptr+2
1682 D79C 20 08 D3              jsr   write_pstring
1683 D79F A9 22 00              lda   #'"'
1684 D7A2 20 F9 D2              jsr   write_char
1685 D7A5 80 06                 bra   @name_drawn
1686 D7A7
1687 D7A7              @its_a_control  
1688 D7A7 A9 40 00              lda   #64
1689 D7AA 20 ED D2              jsr   write_num_str            ; draw the box
1690 D7AD
1691 D7AD              @name_drawn  
1692 D7AD A2 19 00              ldx   #25                      ; get prompt string for Format call
1693 D7B0 AD 02 D0              lda   which_call               ; was the call Format or Erase?
1694 D7B3 F0 03                 beq   its_format2              ; it was Format
1695 D7B5 A2 1F 00              ldx   #31                      ; get string for Erase call
1696 D7B8 8A           its_format2 txa   
1697 D7B9 20 ED D2              jsr   write_num_str            ; write out the string
1698 D7BC
1699 D7BC 64 BA                 stz   <top_bar_pos             ; assume editable name
1700 D7BE 2C 4E D2              bit   pb_flags                 ; is it really?
1701 D7C1 30 02                 bmi   @editable                ; yes
1702 D7C3 C6 BA                 dec   <top_bar_pos             ; else set FST title inverse
1703 D7C5              @editable  
1704 D7C5 20 6E D6              jsr   draw_top_select          ; draw the list headers
1705 D7C8
1706 D7C8 A9 3E 00              lda   #62                      ; start with the caution message
1707 D7CB 8D 1E D0              sta   currentFST               ; init to show which message is displayed
1708 D7CE 22 50 D2 01           jsl   get_string
1709 D7D2 82 22 FE              brl   txTextBox2               ; draw it in the window
1710 D7D5
1711 D7D5                       EndP 
1712 D7D5
1713 D7D5                       eject 
1714 D7D5              ;==========================================================
1715 D7D5              ;
1716 D7D5              ;  make_tx_ptr
1717 D7D5              ;
1718 D7D5              ;  Form a pointer to a particular member of one of the
1719 D7D5              ;  lists.
1720 D7D5              ;
1721 D7D5              ;  Inputs:      A = entry #
1722 D7D5              ;               tx_list_ptr = pointer to text list record
1723 D7D5              ;
1724 D7D5              ;  Outputs:     tx_list_entry = pointer to one of its members
1725 D7D5              ;               A = trashed
1726 D7D5              ;               X = trashed
1727 D7D5              ;               Y = trashed
1728 D7D5              ;               P = nvmxdizc
1729 D7D5              ;                   ..000...
1730 D7D5              ;
1731 D7D5              ;==========================================================
1732 D7D5
1733 D7D5              make_tx_ptr Proc 
1734 D7D5                       with my_direct_page,tx_list_record
1735 D7D5
1736 D7D5 AA                    tax                            ; if zero, offset = 0
1737 D7D6 F0 0C                 beq   make_tx_ptr_2
1738 D7D8 A9 00 00              lda   #0
1739 D7DB A0 0E 00              ldy   #list_entry_size         ; (offset of entry size)
1740 D7DE
1741 D7DE              make_tx_ptr_1  
1742 D7DE 18                    clc   
1743 D7DF 77 BE                 adc   [<tx_list_ptr],y
1744 D7E1
1745 D7E1 CA                    dex   
1746 D7E2 D0 FA                 bne   make_tx_ptr_1
1747 D7E4
1748 D7E4              make_tx_ptr_2  
1749 D7E4 18                    clc   
1750 D7E5 67 BE                 adc   [<tx_list_ptr]
1751 D7E7 85 C2                 sta   <tx_entry_ptr
1752 D7E9 A0 02 00              ldy   #2
1753 D7EC A9 00 00              lda   #0
1754 D7EF 77 BE                 adc   [<tx_list_ptr],y
1755 D7F1 85 C4                 sta   <tx_entry_ptr+2
1756 D7F3 60                    rts   
1757 D7F4                       EndP 
1758 D7F4
1759 D7F4                       eject 
1760 D7F4              ;==========================================================
1761 D7F4              ;
1762 D7F4              ;  setup_lists
1763 D7F4              ;
1764 D7F4              ;  Plug in data about the member lists and draw the lists.
1765 D7F4              ;
1766 D7F4              ;  Outputs:     A = trashed
1767 D7F4              ;               X = trashed
1768 D7F4              ;               Y = trashed
1769 D7F4              ;               P = nvmxdizc
1770 D7F4              ;                   ..000...
1771 D7F4              ;
1772 D7F4              ;==========================================================
1773 D7F4
1774 D7F4              setup_lists Proc 
1775 D7F4                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
1776 D7F4
1777 D7F4                       with my_direct_page,tx_list_record
1778 D7F4
1779 D7F4 A5 94                 lda   <fst_list_ptr
1780 D7F6 8D D4 D1              sta   |tx_list_1.member_ptr
1781 D7F9 A5 96                 lda   <fst_list_ptr+2
1782 D7FB 8D D6 D1              sta   |tx_list_1.member_ptr+2
1783 D7FE
1784 D7FE A5 9C                 lda   <fst_list_cnt
1785 D800 8D DC D1              sta   |tx_list_1.num_entries
1786 D803
1787 D803 A9 FF FF              lda   #$FFFF                   ; initialize selections
1788 D806 8D DE D1              sta   |tx_list_1.current_entry
1789 D809
1790 D809 1A                    inc   a                        ; init scroll to top
1791 D80A 8D E0 D1              sta   |tx_list_1.top_entry
1792 D80D
1793 D80D A9 D4 D1              lda   #<tx_list_1
1794 D810 85 BE                 sta   <tx_list_ptr
1795 D812 A9 01 00              lda   #^tx_list_1
1796 D815 85 C0                 sta   <tx_list_ptr+2
1797 D817 20 3D D8              jsr   draw_list
1798 D81A
1799 D81A A5 84                 lda   <fmt_list_ptr
1800 D81C 8D E4 D1              sta   |tx_list_2.member_ptr
1801 D81F A5 86                 lda   <fmt_list_ptr+2
1802 D821 8D E6 D1              sta   |tx_list_2.member_ptr+2
1803 D824
1804 D824 A5 8C                 lda   <fmt_disp_cnt
1805 D826 8D EC D1              sta   |tx_list_2.num_entries
1806 D829
1807 D829 A9 FF FF              lda   #$FFFF                   ; initialize selections
1808 D82C 8D EE D1              sta   |tx_list_2.current_entry
1809 D82F
1810 D82F 1A                    inc   a                        ; init scroll to top
1811 D830 8D F0 D1              sta   |tx_list_2.top_entry
1812 D833
1813 D833 A9 E4 D1              lda   #<tx_list_2
1814 D836 85 BE                 sta   <tx_list_ptr
1815 D838 A9 01 00              lda   #^tx_list_2
1816 D83B 85 C0                 sta   <tx_list_ptr+2
1817 D83D              ;	bra	draw_list	; (rts)
1818 D83D                                                      ; fall into draw_list
1819 D83D
1820 D83D                       eject 
1821 D83D              ;==========================================================
1822 D83D              ;
1823 D83D              ;  draw_list
1824 D83D              ;
1825 D83D              ;  Any time one of the lists is changed, call this routine
1826 D83D              ;  to draw it.  Contains auto-scroll logic (if the currently
1827 D83D              ;  selected entry is missing, bring it into view).
1828 D83D              ;
1829 D83D              ;  Inputs:      tx_list_ptr = ptr to text list record
1830 D83D              ;
1831 D83D              ;  Outputs:     A = trashed
1832 D83D              ;               X = trashed
1833 D83D              ;               Y = trashed
1834 D83D              ;               P = nvmxdizc
1835 D83D              ;                   ..000...
1836 D83D              ;
1837 D83D              ;==========================================================
1838 D83D                       Entry draw_list
1839 D83D              draw_list  
1840 D83D                       Import set_list_str
1841 D83D
1842 D83D A0 04 00              ldy   #port                    ; set to this port
1843 D840 B7 BE                 lda   [<tx_list_ptr],y
1844 D842 8F BD B2 00           sta   >set_list_str+3
1845 D846 C8                    iny   
1846 D847 C8                    iny   
1847 D848 B7 BE                 lda   [<tx_list_ptr],y
1848 D84A 8F BF B2 00           sta   >set_list_str+5
1849 D84E A2 BA B2              ldx   #<set_list_str
1850 D851 A0 00 00              ldy   #^set_list_str
1851 D854 20 08 D3              jsr   write_pstring
1852 D857
1853 D857              ; scroll (adjust top #) if current selection not visible
1854 D857
1855 D857 A0 0A 00              ldy   #current_entry           ; A = current sel.
1856 D85A B7 BE                 lda   [<tx_list_ptr],y
1857 D85C C9 FF FF              cmp   #$FFFF                   ; -1 = no selection
1858 D85F F0 1E                 beq   draw_list_0              ; no adjustment.
1859 D861
1860 D861 C8                    iny   
1861 D862 C8                    iny                            ; CMP A vs. top #
1862 D863 D7 BE                 cmp   [<tx_list_ptr],y
1863 D865 B0 04                 bge   draw_list_01             ; bra if not before top
1864 D867
1865 D867 97 BE                 sta   [<tx_list_ptr],y         ; put selection at top of window
1866 D869 80 14                 bra   draw_list_0
1867 D86B
1868 D86B              draw_list_01  
1869 D86B 85 AA                 sta   <init_temp_1             ; see if past bottom edge
1870 D86D B7 BE                 lda   [<tx_list_ptr],y
1871 D86F 18                    clc                            ; A = top + 3
1872 D870 69 03 00              adc   #3
1873 D873 C5 AA                 cmp   <init_temp_1
1874 D875 B0 08                 bge   draw_list_0
1875 D877
1876 D877 A5 AA                 lda   <init_temp_1             ; put selection at 4
1877 D879 38                    sec   
1878 D87A E9 03 00              sbc   #3
1879 D87D 97 BE                 sta   [<tx_list_ptr],y
1880 D87F
1881 D87F              ; draw or erase top arrow
1882 D87F
1883 D87F              draw_list_0  
1884 D87F A0 0C 00              ldy   #top_entry               ; if top is non-zero draw arrow
1885 D882 B7 BE                 lda   [<tx_list_ptr],y
1886 D884 F0 08                 beq   draw_list_1
1887 D886
1888 D886 A9 0E CB              lda   #$CB0E                   ; draw up arrow (normal, arrow)
1889 D889 20 F3 D2              jsr   write_2char
1890 D88C 80 06                 bra   draw_list_2
1891 D88E
1892 D88E              draw_list_1  
1893 D88E A9 0E 20              lda   #$200E                   ; clear up arrow (normal, space)
1894 D891 20 F3 D2              jsr   write_2char
1895 D894
1896 D894              ;  draw or erase bottom arrow
1897 D894
1898 D894              draw_list_2  
1899 D894 A0 08 00              ldy   #num_entries             ; if len-top >= 5 draw down arr.
1900 D897 B7 BE                 lda   [<tx_list_ptr],y
1901 D899 38                    sec   
1902 D89A A0 0C 00              ldy   #top_entry
1903 D89D F7 BE                 sbc   [<tx_list_ptr],y
1904 D89F C9 05 00              cmp   #5
1905 D8A2 90 14                 blt   draw_list_3
1906 D8A4
1907 D8A4 A9 1E 00 20           _gotoxy 0,3
1908 D8B0
1909 D8B0 A9 CA 19              lda   #$19CA                   ; down arrow, home cursor
1910 D8B3 20 F3 D2              jsr   write_2char
1911 D8B6 80 12                 bra   draw_list_4
1912 D8B8
1913 D8B8              draw_list_3  
1914 D8B8 A9 1E 00 20           _gotoxy 0,3
1915 D8C4
1916 D8C4 A9 20 19              lda   #$1920                   ; space, home cursor
1917 D8C7 20 F3 D2              jsr   write_2char
1918 D8CA
1919 D8CA              ;  draw entries one by one
1920 D8CA
1921 D8CA              draw_list_4  
1922 D8CA A0 0C 00              ldy   #top_entry
1923 D8CD B7 BE                 lda   [<tx_list_ptr],y
1924 D8CF 85 BC                 sta   <tx_cur_entry
1925 D8D1
1926 D8D1 A9 04 00              lda   #4                       ; how many to draw
1927 D8D4
1928 D8D4 85 B2                 sta   <init_temp_3
1929 D8D6
1930 D8D6              ;  loop here per entry
1931 D8D6
1932 D8D6              draw_list_5  
1933 D8D6 A5 BC                 lda   <tx_cur_entry
1934 D8D8 A0 08 00              ldy   #num_entries             ; past end?
1935 D8DB D7 BE                 cmp   [<tx_list_ptr],y
1936 D8DD 90 09                 blt   draw_list_55
1937 D8DF
1938 D8DF              ;  we are past the end.  just clear the line
1939 D8DF
1940 D8DF A9 1A 00              lda   #clearLine               ; this would erase the arrows
1941 D8E2 20 F9 D2              jsr   write_char               ; but think, no arrows could be
1942 D8E5 82 6D 00              brl   draw_list_9
1943 D8E8
1944 D8E8              ;  this is a real entry
1945 D8E8
1946 D8E8              draw_list_55  
1947 D8E8 20 D5 D7              jsr   make_tx_ptr              ; make pointer to mem list entry
1948 D8EB
1949 D8EB A5 BC                 lda   <tx_cur_entry            ; if selected one, draw inversed
1950 D8ED A0 0A 00              ldy   #current_entry
1951 D8F0 D7 BE                 cmp   [<tx_list_ptr],y
1952 D8F2 F0 1B                 beq   draw_list_6
1953 D8F4
1954 D8F4 A0 04 00              ldy   #4                       ; if disabled, draw parens
1955 D8F7 B7 C2                 lda   [<tx_entry_ptr],y        ; get mem_flag from record
1956 D8F9 29 20 00              and   #$0020                   ; check bit 5
1957 D8FC D0 22                 bne   draw_list_7              ; not selectable
1958 D8FE
1959 D8FE              ;  prepare for normal, selectable.
1960 D8FE
1961 D8FE A9 1C 1C              lda   #$1C1C                   ; forward
1962 D901 20 F3 D2              jsr   write_2char
1963 D904 A9 20 00              lda   #' '
1964 D907 20 F9 D2              jsr   write_char
1965 D90A 62 31 00              per   finish_normal-1
1966 D90D 80 20                 bra   draw_list_8
1967 D90F
1968 D90F              ;  prepare for selected item
1969 D90F
1970 D90F              draw_list_6  
1971 D90F A9 1C 1C              lda   #$1C1C                   ; forward 2
1972 D912 20 F3 D2              jsr   write_2char
1973 D915 A9 0F 20              lda   #$200F                   ; inverse, space
1974 D918 20 F3 D2              jsr   write_2char
1975 D91B
1976 D91B 62 28 00              per   finish_sel-1
1977 D91E 80 0F                 bra   draw_list_8
1978 D920
1979 D920              ;  prepare for disabled item
1980 D920
1981 D920              draw_list_7  
1982 D920 A9 1C 1C              lda   #$1C1C                   ; forward
1983 D923 20 F3 D2              jsr   write_2char
1984 D926 A9 28 00              lda   #'('
1985 D929 20 F9 D2              jsr   write_char
1986 D92C 62 1F 00              per   finish_disa-1
1987 D92F
1988 D92F              ;  now draw the member string
1989 D92F
1990 D92F              draw_list_8  
1991 D92F A7 C2                 lda   [<tx_entry_ptr]
1992 D931 AA                    tax   
1993 D932 85 AE                 sta   <init_temp_2
1994 D934 A0 02 00              ldy   #2
1995 D937 B7 C2                 lda   [<tx_entry_ptr],y
1996 D939 A8                    tay   
1997 D93A 85 B0                 sta   <init_temp_2+2
1998 D93C
1999 D93C 82 C9 F9              brl   write_pstring            ; rts to previously pushed addr
2000 D93F
2001 D93F              finish_normal  
2002 D93F A9 20 00              lda   #' '
2003 D942 20 F9 D2              jsr   write_char
2004 D945 80 0E                 bra   draw_list_9
2005 D947
2006 D947              finish_sel  
2007 D947 A9 20 0E              lda   #$0E20                   ; space, normal
2008 D94A 20 F3 D2              jsr   write_2char
2009 D94D 80 06                 bra   draw_list_9
2010 D94F
2011 D94F              finish_disa  
2012 D94F A9 29 00              lda   #')'
2013 D952 20 F9 D2              jsr   write_char
2014 D955
2015 D955              ;  now pad field, CR and go to next one
2016 D955
2017 D955              draw_list_9  
2018 D955 A7 AE                 lda   [<init_temp_2]           ; now calc length for padding
2019 D957 29 FF 00              and   #$00FF
2020 D95A 48                    pha   
2021 D95B 38                    sec   
2022 D95C A9 2F 00              lda   #15+32
2023 D95F E3 01                 sbc   1,s
2024 D961 29 FF 00              and   #$00FF
2025 D964 09 00 0D              ora   #$0D00
2026 D967 8F B8 B2 00           sta   >std_buffer+2
2027 D96B A9 03 10              lda   #$1003                   ; pstring: $10 char_count CR
2028 D96E 8F B6 B2 00           sta   >std_buffer
2029 D972 68                    pla   
2030 D973 A2 B6 B2              ldx   #<std_buffer
2031 D976 A0 00 00              ldy   #^std_buffer
2032 D979 20 08 D3              jsr   write_pstring
2033 D97C
2034 D97C E6 BC                 inc   <tx_cur_entry
2035 D97E C6 B2                 dec   <init_temp_3
2036 D980 F0 03                 beq   draw_list_10
2037 D982 82 51 FF              brl   draw_list_5
2038 D985
2039 D985              draw_list_10  
2040 D985 A9 04 00              lda   #$04                     ; pop vp
2041 D988 82 6E F9              brl   write_char               ; (rts)
2042 D98B                       EndP 
2043 D98B
2044 D98B                       eject 
2045 D98B              ;==========================================================
2046 D98B              ;
2047 D98B              ;  choose_fmt
2048 D98B              ;
2049 D98B              ;  Pick a format to select, by the following algorithm:
2050 D98B              ;
2051 D98B              ;  (1)  If a format already selected & it's enabled, stay w/it.
2052 D98B              ;  (2)  If the driver's 'default' is available, choose it.
2053 D98B              ;  (3)  Else just take whatever is available.
2054 D98B              ;
2055 D98B              ;  Outputs:     A = trashed
2056 D98B              ;               X = trashed
2057 D98B              ;               Y = trashed
2058 D98B              ;               P = nvmxdizc
2059 D98B              ;                   ..000...
2060 D98B              ;
2061 D98B              ;==========================================================
2062 D98B
2063 D98B              choose_fmt Proc 
2064 D98B                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2065 D98B                       with my_direct_page,fmt_list_record
2066 D98B
2067 D98B A9 E4 D1              lda   #<tx_list_2
2068 D98E 85 BE                 sta   <tx_list_ptr
2069 D990 A9 01 00              lda   #^tx_list_2
2070 D993 85 C0                 sta   <tx_list_ptr+2
2071 D995
2072 D995 AD EE D1              lda   |tx_list_2.current_entry
2073 D998 C9 FF FF              cmp   #$FFFF
2074 D99B F0 0E                 beq   choose_fmt_1             ; nothing selected.
2075 D99D
2076 D99D 20 D5 D7              jsr   make_tx_ptr              ; selected.  see if available.
2077 D9A0
2078 D9A0 A0 04 00              ldy   #df_mem_flag
2079 D9A3 B7 C2                 lda   [<tx_entry_ptr],y
2080 D9A5 29 20 00              and   #$0020                   ; disable bit
2081 D9A8 D0 01                 bne   choose_fmt_1
2082 D9AA 60                    rts                            ; dis. bit off = enabled.  stay.
2083 D9AB
2084 D9AB              ;  The current selection is not available.  Try the driver default.
2085 D9AB
2086 D9AB              choose_fmt_1  
2087 D9AB 64 AA                 stz   <init_temp_1             ; entry counter
2088 D9AD
2089 D9AD              choose_fmt_2  
2090 D9AD A5 AA                 lda   <init_temp_1
2091 D9AF 20 D5 D7              jsr   make_tx_ptr
2092 D9B2
2093 D9B2 A0 0E 00              ldy   #df_conf_num
2094 D9B5 B7 C2                 lda   [<tx_entry_ptr],y
2095 D9B7 C5 9E                 cmp   <fmt_def_fmt
2096 D9B9 D0 0C                 bne   choose_fmt_3
2097 D9BB
2098 D9BB A0 04 00              ldy   #df_mem_flag             ; got it!  enabled?
2099 D9BE B7 C2                 lda   [<tx_entry_ptr],y
2100 D9C0 29 20 00              and   #$0020
2101 D9C3 D0 0A                 bne   choose_fmt_4             ; no.  no need to keep looping
2102 D9C5 80 1D                 bra   choose_fmt_6
2103 D9C7
2104 D9C7              choose_fmt_3  
2105 D9C7 E6 AA                 inc   <init_temp_1             ; loop and try another
2106 D9C9 A5 AA                 lda   <init_temp_1
2107 D9CB C5 8C                 cmp   <fmt_disp_cnt
2108 D9CD D0 DE                 bne   choose_fmt_2
2109 D9CF
2110 D9CF              ;  default didn't work.  just take whatever's out there!
2111 D9CF
2112 D9CF              choose_fmt_4  
2113 D9CF 64 AA                 stz   <init_temp_1
2114 D9D1
2115 D9D1              choose_fmt_5  
2116 D9D1 A5 AA                 lda   <init_temp_1
2117 D9D3 20 D5 D7              jsr   make_tx_ptr
2118 D9D6
2119 D9D6 A0 04 00              ldy   #df_mem_flag             ; available?
2120 D9D9 B7 C2                 lda   [<tx_entry_ptr],y
2121 D9DB 29 20 00              and   #$0020
2122 D9DE F0 04                 beq   choose_fmt_6
2123 D9E0
2124 D9E0 E6 AA                 inc   <init_temp_1             ; no need to test.  something
2125 D9E2 80 ED                 bra   choose_fmt_5             ; must be available!
2126 D9E4
2127 D9E4              choose_fmt_6  
2128 D9E4 A5 AA                 lda   <init_temp_1             ; we like it.  select it.
2129 D9E6 8D EE D1              sta   |tx_list_2.current_entry
2130 D9E9 82 51 FE              brl   draw_list                ; update screen.
2131 D9EC                       EndP 
2132 D9EC
2133 D9EC                       eject 
2134 D9EC              ;==========================================================
2135 D9EC              ;
2136 D9EC              ;  do_down_arrow
2137 D9EC              ;
2138 D9EC              ;  When the down arrow is pressed, move a selection bar
2139 D9EC              ;  to the next available option.  If none, just freeze.
2140 D9EC              ;
2141 D9EC              ;  Inputs:      top_bar_pos = -1 for FS, 1 for FMT
2142 D9EC              ;
2143 D9EC              ;  Outputs:     A = trashed
2144 D9EC              ;               X = trashed
2145 D9EC              ;               Y = trashed
2146 D9EC              ;               P = nvmxdizc
2147 D9EC              ;                   ..000...
2148 D9EC              ;
2149 D9EC              ;==========================================================
2150 D9EC
2151 D9EC              do_down_arrow Proc 
2152 D9EC                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2153 D9EC
2154 D9EC                       with my_direct_page,tx_list_record,fst_list_record
2155 D9EC
2156 D9EC A2 D4 D1              ldx   #<tx_list_1              ; which is current?
2157 D9EF A0 01 00              ldy   #^tx_list_1
2158 D9F2
2159 D9F2 A5 BA                 lda   <top_bar_pos
2160 D9F4 30 06                 bmi   do_down_1
2161 D9F6
2162 D9F6 A2 E4 D1              ldx   #<tx_list_2              ; oops, guessed wrong
2163 D9F9 A0 01 00              ldy   #^tx_list_2
2164 D9FC
2165 D9FC              do_down_1  
2166 D9FC 86 BE                 stx   <tx_list_ptr
2167 D9FE 84 C0                 sty   <tx_list_ptr+2
2168 DA00
2169 DA00              ;  starting with the current entry +1, look for an opening
2170 DA00
2171 DA00 A0 0A 00              ldy   #current_entry
2172 DA03 B7 BE                 lda   [<tx_list_ptr],y         ; current entry #
2173 DA05 48                    pha   
2174 DA06
2175 DA06              do_down_lp  
2176 DA06 A3 01                 lda   1,s
2177 DA08 1A                    inc   a
2178 DA09 83 01                 sta   1,s
2179 DA0B
2180 DA0B A0 08 00              ldy   #num_entries             ; see if at last yet
2181 DA0E D7 BE                 cmp   [<tx_list_ptr],y
2182 DA10 F0 2A                 beq   do_down_2                ; if so, no change!
2183 DA12
2184 DA12 20 D5 D7              jsr   make_tx_ptr              ; not last.  see if avail.
2185 DA15
2186 DA15 A0 04 00              ldy   #ff_mem_flag             ; check enable/disable bits
2187 DA18 B7 C2                 lda   [<tx_entry_ptr],y
2188 DA1A 29 20 00              and   #$0020
2189 DA1D F0 16                 beq   @select_it               ; enabled, so select it
2190 DA1F A3 01                 lda   1,s                      ; get the entry number again
2191 DA21 A0 0C 00              ldy   #top_entry               ; is this entry below the bottom?
2192 DA24 38                    sec   
2193 DA25 E9 03 00              sbc   #3
2194 DA28 D7 BE                 cmp   [<tx_list_ptr],y
2195 DA2A F0 DA                 beq   do_down_lp
2196 DA2C 90 D8                 bcc   do_down_lp               ; within window, keep searching
2197 DA2E B7 BE                 lda   [<tx_list_ptr],y         ; else must adjust top entry
2198 DA30 1A                    inc   a
2199 DA31 97 BE                 sta   [<tx_list_ptr],y
2200 DA33 80 D1                 bra   do_down_lp               ; try another.
2201 DA35
2202 DA35              @select_it  
2203 DA35 A3 01                 lda   1,s                      ; this one is active
2204 DA37 A0 0A 00              ldy   #current_entry
2205 DA3A 97 BE                 sta   [<tx_list_ptr],y         ; set new current #
2206 DA3C
2207 DA3C              ;  and redraw the list
2208 DA3C
2209 DA3C              do_down_2  
2210 DA3C 68                    pla   
2211 DA3D 20 3D D8              jsr   draw_list
2212 DA40
2213 DA40              ;  finally, fix fmt enable bits for this fst
2214 DA40
2215 DA40 80 4B                 bra   fix_fmt_bits             ; (see do_up_arrow)
2216 DA42
2217 DA42                       eject 
2218 DA42              ;==========================================================
2219 DA42              ;
2220 DA42              ;  do_up_arrow
2221 DA42              ;
2222 DA42              ;  When the up arrow is pressed, move a selection bar
2223 DA42              ;  to the previous available option.  If none, just freeze.
2224 DA42              ;
2225 DA42              ;  Inputs:      top_bar_pos = -1 for FS, 1 for FMT
2226 DA42              ;
2227 DA42              ;  Outputs:     A = trashed
2228 DA42              ;               X = trashed
2229 DA42              ;               Y = trashed
2230 DA42              ;               P = nvmxdizc
2231 DA42              ;                   ..000...
2232 DA42              ;
2233 DA42              ;==========================================================
2234 DA42                       entry do_up_arrow
2235 DA42              do_up_arrow  
2236 DA42                       Import jsl_fst_ptr
2237 DA42
2238 DA42 A2 D4 D1              ldx   #<tx_list_1              ; which is current?
2239 DA45 A0 01 00              ldy   #^tx_list_1
2240 DA48
2241 DA48 A5 BA                 lda   <top_bar_pos
2242 DA4A 30 06                 bmi   do_up_1
2243 DA4C
2244 DA4C A2 E4 D1              ldx   #<tx_list_2              ; oops, guessed wrong
2245 DA4F A0 01 00              ldy   #^tx_list_2
2246 DA52
2247 DA52              do_up_1   
2248 DA52 86 BE                 stx   <tx_list_ptr
2249 DA54 84 C0                 sty   <tx_list_ptr+2
2250 DA56
2251 DA56              ;  starting with the current entry -1, look for an opening
2252 DA56
2253 DA56 A0 0A 00              ldy   #current_entry
2254 DA59 B7 BE                 lda   [<tx_list_ptr],y         ; current entry #
2255 DA5B 48                    pha   
2256 DA5C
2257 DA5C              do_up_lp  
2258 DA5C A3 01                 lda   1,s
2259 DA5E F0 29                 beq   do_up_2                  ; top.  can't go further.
2260 DA60
2261 DA60 3A                    dec   a
2262 DA61 83 01                 sta   1,s
2263 DA63 20 D5 D7              jsr   make_tx_ptr              ; not last.  see if avail.
2264 DA66
2265 DA66 A0 04 00              ldy   #4                       ; check enable/disable bits
2266 DA69 B7 C2                 lda   [<tx_entry_ptr],y
2267 DA6B 29 20 00              and   #$0020
2268 DA6E F0 12                 beq   @select_it               ; enabled, select it
2269 DA70 A3 01                 lda   1,s                      ; get the entry number again
2270 DA72 A0 0C 00              ldy   #top_entry               ; is it off the top?
2271 DA75 D7 BE                 cmp   [<tx_list_ptr],y         ; below this entry?
2272 DA77 B0 E3                 bcs   do_up_lp                 ; within window, continue searching
2273 DA79 B7 BE                 lda   [<tx_list_ptr],y         ; else must adjust top entry
2274 DA7B 3A                    dec   a
2275 DA7C 30 DE                 bmi   do_up_lp                 ; can't be > 0
2276 DA7E 97 BE                 sta   [<tx_list_ptr],y
2277 DA80 80 DA                 bra   do_up_lp                 ; no.  try another.
2278 DA82
2279 DA82              @select_it  
2280 DA82 A3 01                 lda   1,s                      ; this one is active
2281 DA84 A0 0A 00              ldy   #current_entry
2282 DA87 97 BE                 sta   [<tx_list_ptr],y         ; set new current #
2283 DA89
2284 DA89              ;  fix stack and redraw the list
2285 DA89
2286 DA89              do_up_2   
2287 DA89 68                    pla   
2288 DA8A 20 3D D8              jsr   draw_list
2289 DA8D
2290 DA8D              ;  if it was an fst, adjust format enable bits
2291 DA8D
2292 DA8D              fix_fmt_bits  
2293 DA8D A5 BA                 lda   <top_bar_pos
2294 DA8F 10 1B                 bpl   q_fix
2295 DA91
2296 DA91 AD DE D1              lda   |tx_list_1.current_entry
2297 DA94 22 91 D4 00           jsl   jsl_fst_ptr              ; setting up fst_list_entry
2298 DA98 22 A4 DB 00           jsl   fst_adj_fmts
2299 DA9C 20 8B D9              jsr   choose_fmt
2300 DA9F
2301 DA9F A2 E4 D1              ldx   #<tx_list_2              ; and redraw the format list
2302 DAA2 A0 01 00              ldy   #^tx_list_2
2303 DAA5 86 BE                 stx   <tx_list_ptr
2304 DAA7 84 C0                 sty   <tx_list_ptr+2
2305 DAA9
2306 DAA9 20 3D D8              jsr   draw_list
2307 DAAC
2308 DAAC              q_fix     
2309 DAAC 60                    rts   
2310 DAAD                       EndP 
2311 DAAD
2312 DAAD                       eject 
2313 DAAD              ;==========================================================
2314 DAAD              ;
2315 DAAD              ;  tx_too_big
2316 DAAD              ;
2317 DAAD              ;  If the current fst is not big enough for the current
2318 DAAD              ;  format, we will let them format, but we give them a
2319 DAAD              ;  nasty note.
2320 DAAD              ;
2321 DAAD              ;  e.g. ProDOS (32Mb max) onto an HD40SC.
2322 DAAD              ;
2323 DAAD              ;  Outputs:     A = trashed
2324 DAAD              ;               X = trashed
2325 DAAD              ;               Y = trashed
2326 DAAD              ;               P = nvmxdizc
2327 DAAD              ;                   ..000...
2328 DAAD              ;
2329 DAAD              ;==========================================================
2330 DAAD
2331 DAAD              tx_too_big Proc 
2332 DAAD                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2333 DAAD                       Import chk_fst_size,jsl_fmt_ptr,jsl_fst_ptr
2334 DAAD                       Import get_string
2335 DAAD
2336 DAAD 18                    clc   
2337 DAAE AD DE D1              lda   |tx_list_1.current_entry ; make fst and fmt pointers
2338 DAB1 30 27                 bmi   tx_no_warn               ; no FST currently selected
2339 DAB3 22 91 D4 00           jsl   jsl_fst_ptr
2340 DAB7 18                    clc   
2341 DAB8 AD EE D1              lda   |tx_list_2.current_entry
2342 DABB 30 1D                 bmi   tx_no_warn               ; no format currently selected
2343 DABD 22 73 D4 00           jsl   jsl_fmt_ptr
2344 DAC1
2345 DAC1              ;  find out if the current pair is ok
2346 DAC1
2347 DAC1 22 13 D6 00           jsl   chk_fst_size             ; fills the string if a problem
2348 DAC5 90 13                 bcc   tx_no_warn
2349 DAC7
2350 DAC7              ;  and display the warning (if there is one)
2351 DAC7
2352 DAC7 A9 1C 00              lda   #28                      ; warning string
2353 DACA CD 1E D0              cmp   currentFST               ; is the message already displayed?
2354 DACD F0 0B                 beq   tx_no_warn               ; yes, just leave it up
2355 DACF
2356 DACF 8D 1E D0              sta   currentFST
2357 DAD2 22 50 D2 01           jsl   get_string
2358 DAD6 20 F7 D5              jsr   txTextBox2               ; draw the text
2359 DAD9 38                    sec                            ; signify that the message was drawn
2360 DADA
2361 DADA              ;  no warning.  determine if we need to change the current message
2362 DADA
2363 DADA              tx_no_warn  
2364 DADA 60                    rts   
2365 DADB                       EndP 
2366 DADB
2367 DADB                       eject 
2368 DADB              ;==========================================================
2369 DADB              ;
2370 DADB              ;  tx_check_name
2371 DADB              ;
2372 DADB              ;  Performs a full JudgeName call with the user-supplied
2373 DADB              ;  volume name prior to exiting the dialog box.
2374 DADB              ;
2375 DADB              ;  Outputs:     P = nvmxdizc
2376 DADB              ;                   ..000..|
2377 DADB              ;                          0=no error, 1=name not acceptable
2378 DADB              ;
2379 DADB              ;  Direct page variable usage is:
2380 DADB              ;
2381 DADB              ;       init_temp_2 = pointer to JudgeName result buffer
2382 DADB              ;       init_temp_3 = VP of result buffer
2383 DADB              ;       init_temp_4 = pointer to source of name
2384 DADB              ;
2385 DADB              ;==========================================================
2386 DADB
2387 DADB              tx_check_name Proc Export
2388 DADB                       Import call_judgename
2389 DADB                       Import call_deref,call_alloc,call_release
2390 DADB                       Import call_lock_mem,call_unlock_mem
2391 DADB                       Import jn_parms:jn_parmBlock
2392 DADB
2393 DADB                       with my_direct_page,fst_list_record
2394 DADB                       with jn_parms                  ; gonna use JudgeName parmblock
2395 DADB
2396 DADB              ; first convert the Pascal string to a GS/OS result buffer containing the name
2397 DADB
2398 DADB A9 24 00              lda   #36                      ; GS/OS result buffer
2399 DADE 22 00 D4 00           jsl   call_alloc               ; allocate memory for the pathname
2400 DAE2 86 B2                 stx   init_temp_3              ; save VP
2401 DAE4 84 B4                 sty   init_temp_3+2
2402 DAE6 22 20 D4 00           jsl   call_lock_mem            ; lock it down
2403 DAEA A6 B2                 ldx   init_temp_3              ; deref the VP
2404 DAEC A4 B4                 ldy   init_temp_3+2
2405 DAEE 22 08 D4 00           jsl   call_deref               ; turn it into a pointer
2406 DAF2 86 AE                 stx   init_temp_2              ; save pointer
2407 DAF4 84 B0                 sty   init_temp_2+2
2408 DAF6 8A                    txa                            ; save in JudgeName parmblock too
2409 DAF7 8F 8D B2 00           sta   >jn_parms.name
2410 DAFB 98                    tya   
2411 DAFC 8F 8F B2 00           sta   >jn_parms.name+2
2412 DB00
2413 DB00 A9 24 00              lda   #36                      ; buffer length
2414 DB03 87 AE                 sta   [init_temp_2]            ; store in buffer
2415 DB05 A5 AE                 lda   <init_temp_2             ; now adjust pointer past length words
2416 DB07 18                    clc   
2417 DB08 69 03 00              adc   #3
2418 DB0B 85 AE                 sta   <init_temp_2
2419 DB0D 90 02                 bcc   @no_carry
2420 DB0F E6 B0                 inc   <init_temp_2+2
2421 DB11              @no_carry  
2422 DB11
2423 DB11 A5 C6                 lda   <txt_name_ptr            ; this is the source pointer
2424 DB13 85 B6                 sta   <init_temp_4
2425 DB15 A5 C8                 lda   <txt_name_ptr+2
2426 DB17 85 B8                 sta   <init_temp_4+2
2427 DB19 A7 C6                 lda   [<txt_name_ptr]          ; get the current length
2428 DB1B 29 FF 00              and   #$00FF                   ; clear garbage byte
2429 DB1E              do_copy   
2430 DB1E 48                    pha                            ; save till after copy
2431 DB1F A8                    tay                            ; into Y for indexing
2432 DB20 F0 0B                 beq   @its_null                ; oops!  NULL volume name, skip copy
2433 DB22 E2 20                 sep   #$20                     ; 8-bit accumulator
2434 DB24              @loop     
2435 DB24 B7 B6                 lda   [<init_temp_4],y         ; move string to our buffer
2436 DB26 97 AE                 sta   [<init_temp_2],y
2437 DB28 88                    dey   
2438 DB29 D0 F9                 bne   @loop                    ; until all copied
2439 DB2B C2 20                 rep   #$20                     ; back to 16-bit accumulator
2440 DB2D              @its_null  
2441 DB2D A5 AE                 lda   <init_temp_2             ; adjust pointer back to beginning of string
2442 DB2F D0 02                 bne   @1
2443 DB31 C6 B0                 dec   <init_temp_2+2
2444 DB33              @1        
2445 DB33 C6 AE                 dec   <init_temp_2
2446 DB35 68                    pla                            ; retrieve length
2447 DB36 87 AE                 sta   [<init_temp_2]           ; set string length
2448 DB38
2449 DB38              ; now we can see if the FST is happy with the supplied name
2450 DB38
2451 DB38 A9 06 00              lda   #6                       ; reset pCount
2452 DB3B 8F 81 B2 00           sta   >jn_parms.pCount
2453 DB3F
2454 DB3F A0 08 00              ldy   #ff_fs_num               ; get the FST ID
2455 DB42 B7 C2                 lda   [tx_entry_ptr],y         ; (tx_entry_ptr set up by caller)
2456 DB44 8F 83 B2 00           sta   >jn_parms.fileSysID
2457 DB48
2458 DB48 A9 00 00              lda   #0
2459 DB4B 8F 91 B2 00           sta   >jn_parms.nameFlags      ;clear translation flags
2460 DB4F
2461 DB4F F4 00 00              pea   call_judgename>>16
2462 DB52 F4 36 B2              pea   call_judgename
2463 DB55 F4 00 00              pea   0
2464 DB58 22 87 B1 00           jsl   >lc_dispatcher           ; call JudgeName to get the prompt pointer
2465 DB5C
2466 DB5C 22 28 D4 00           jsl   call_unlock_mem          ; unlock memory
2467 DB60
2468 DB60 A6 B2                 ldx   <init_temp_3             ; release the result buffer
2469 DB62 A4 B4                 ldy   <init_temp_3+2
2470 DB64 22 10 D4 00           jsl   call_release
2471 DB68
2472 DB68 AF 91 B2 00           lda   >jn_parms.nameFlags      ; was the FST happy?
2473 DB6C 29 00 E0              and   #$E000                   ; mask off reserved bits
2474 DB6F C9 01 00              cmp   #$0001                   ; condition carry
2475 DB72 60                    rts                            ; and return
2476 DB73
2477 DB73                       EndP 
2478 DB73
2479 DB73                       eject 
2480 DB73              ;==========================================================
2481 DB73              ;
2482 DB73              ;  force_message
2483 DB73              ;
2484 DB73              ;  Forces the drawing of the JudgeName prompt, unless it's
2485 DB73              ;  already being displayed.  
2486 DB73              ;
2487 DB73              ;  chk_message
2488 DB73              ;
2489 DB73              ;  Updates the contents of the message area in the dialog.
2490 DB73              ;
2491 DB73              ;  Outputs:     A = trashed
2492 DB73              ;               X = trashed
2493 DB73              ;               Y = trashed
2494 DB73              ;               P = nvmxdizc
2495 DB73              ;                   ..000...
2496 DB73              ;
2497 DB73              ;==========================================================
2498 DB73
2499 DB73              chk_message Proc 
2500 DB73                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2501 DB73                       Import get_string
2502 DB73
2503 DB73                       with my_direct_page,fst_list_record
2504 DB73
2505 DB73 A5 BA                 lda   <top_bar_pos             ; which 'control' is the active control?
2506 DB75 F0 05                 beq   force_message            ; the editLine 'control', draw the prompt
2507 DB77
2508 DB77 20 AD DA              jsr   tx_too_big               ; update warning string
2509 DB7A B0 33                 bcs   done                     ; if message drawn, skip prompt
2510 DB7C
2511 DB7C                       entry force_message
2512 DB7C              force_message  
2513 DB7C AD DE D1              lda   |tx_list_1.current_entry  ; get currently selected FST
2514 DB7F CD 1E D0              cmp   currentFST               ; same as currently displayed msg #?
2515 DB82 F0 2B                 beq   done                     ; yes, just leave it alone
2516 DB84 C9 FF FF              cmp   #-1                      ; is anything selected?
2517 DB87 F0 26                 beq   done                     ; no, skip it
2518 DB89 2C 4E D2              bit   pb_flags                 ; is the name editable?
2519 DB8C 10 21                 bpl   done                     ; no, there's no need to show the message
2520 DB8E A9 D4 D1              lda   #tx_list_1               ; else must put up new message
2521 DB91 85 BE                 sta   <tx_list_ptr
2522 DB93 A9 01 00              lda   #^tx_list_1
2523 DB96 85 C0                 sta   <tx_list_ptr+2
2524 DB98 AD DE D1              lda   |tx_list_1.current_entry ; get the FST number again
2525 DB9B 8D 1E D0              sta   currentFST               ; save for comparison later
2526 DB9E 20 D5 D7              jsr   make_tx_ptr              ; make a pointer to the member record
2527 DBA1 A0 1C 00              ldy   #ff_prompt               ; get the pointer to the JudgeName prompt
2528 DBA4 B7 C2                 lda   [tx_entry_ptr],y
2529 DBA6 AA                    tax   
2530 DBA7 C8                    iny   
2531 DBA8 C8                    iny   
2532 DBA9 B7 C2                 lda   [tx_entry_ptr],y
2533 DBAB A8                    tay   
2534 DBAC 20 F7 D5              jsr   txTextBox2               ; draw the string
2535 DBAF              done      
2536 DBAF 60                    rts   
2537 DBB0                       EndP 
2538 DBB0
2539 DBB0                       eject 
2540 DBB0              ;==========================================================
2541 DBB0              ;
2542 DBB0              ;  handle_edit
2543 DBB0              ;
2544 DBB0              ;  Handles the actions necessary when the editLine 'control'
2545 DBB0              ;  is the currently active control
2546 DBB0              ;
2547 DBB0              ;  Outputs:     init_choice = 0 if ok pressed,
2548 DBB0              ;                             1 if cancel
2549 DBB0              ;               top_bar_pos = -1 if tab is pressed
2550 DBB0              ;
2551 DBB0              ;               A = trashed
2552 DBB0              ;               X = trashed
2553 DBB0              ;               Y = trashed
2554 DBB0              ;               P = nvmxdizc
2555 DBB0              ;                   ..000...
2556 DBB0              ;
2557 DBB0              ;==========================================================
2558 DBB0
2559 DBB0              handle_edit Proc 
2560 DBB0                       Import term_list,term_list_len:equ
2561 DBB0                       Import input_port:InputPortRec
2562 DBB0                       with my_direct_page
2563 DBB0
2564 DBB0              ; first, we have to set the default string
2565 DBB0
2566 DBB0 A9 04 80              lda   #$8004                   ; SetDefaultString
2567 DBB3 85 16                 sta   <drvr_ctrl_code
2568 DBB5 A9 06 00              lda   #drvr_control            ; make a control call
2569 DBB8 85 02                 sta   <drvr_call_num
2570 DBBA A7 C6                 lda   [<txt_name_ptr]          ; get length of current name
2571 DBBC 29 FF 00              and   #$00ff                   ; that's our request count
2572 DBBF A4 C8                 ldy   <txt_name_ptr+2          ; get pointer to buffer
2573 DBC1 A6 C6                 ldx   <txt_name_ptr
2574 DBC3 E8                    inx                            ; bump past length byte
2575 DBC4 D0 01                 bne   @1
2576 DBC6 C8                    iny   
2577 DBC7              @1        
2578 DBC7 20 B6 D2              jsr   console_dispatch         ; make the control call
2579 DBCA
2580 DBCA              ; position the cursor to the beginning of the input field
2581 DBCA
2582 DBCA              read_reentry  
2583 DBCA A9 1E 00 20           _gotoxy 9,4
2584 DBD6
2585 DBD6              ; now we can enter UIR mode and let the user edit the string
2586 DBD6
2587 DBD6 A9 00 00              lda   #0                       ; turn on UIR
2588 DBD9 8F B6 B2 00           sta   >std_buffer
2589 DBDD A9 03 80              lda   #$8003                   ; SetReadMode
2590 DBE0 20 A6 D2              jsr   call_control             ; make the control call
2591 DBE3
2592 DBE3 A9 02 00              lda   #drvr_read               ; do the read
2593 DBE6 85 02                 sta   <drvr_call_num
2594 DBE8 AD 0A D0              lda   |cons_dev_num
2595 DBEB 85 00                 sta   <drvr_dev_num
2596 DBED A5 C6                 lda   <txt_name_ptr
2597 DBEF A6 C8                 ldx   <txt_name_ptr+2
2598 DBF1 1A                    inc   a                        ;bump past length byte
2599 DBF2 D0 01                 bne   @2
2600 DBF4 E8                    inx   
2601 DBF5              @2        
2602 DBF5 85 04                 sta   <drvr_slist_ptr
2603 DBF7 86 06                 stx   <drvr_slist_ptr+2
2604 DBF9 A9 20 00              lda   #32                      ;maximum of 32 characters
2605 DBFC 85 08                 sta   <drvr_req_cnt
2606 DBFE 64 0A                 stz   <drvr_req_cnt+2
2607 DC00 22 18 D4 00           jsl   >call_dispatch
2608 DC04
2609 DC04 A5 0C                 lda   <drvr_tran_cnt           ; retrieve the string length
2610 DC06 85 B6                 sta   <init_temp_4             ; store here temporarily
2611 DC08
2612 DC08              ; now that we're back from the console driver, turn off UIR mode
2613 DC08
2614 DC08 A9 00 80              lda   #$8000                   ; turn off UIR
2615 DC0B 8F B6 B2 00           sta   >std_buffer
2616 DC0F A9 03 80              lda   #$8003                   ; SetReadMode
2617 DC12 20 A6 D2              jsr   call_control             ; make the control call
2618 DC15
2619 DC15              ; now we get the current Input Port settings to determine which terminator
2620 DC15              ; halted the Console Driver read
2621 DC15
2622 DC15 20 D7 D2              jsr   get_input_port           ; go get the InputPortRec
2623 DC18
2624 DC18 AF D9 B2 00           lda   >input_port.exitType     ; get the terminator number
2625 DC1C 29 FF 00              and   #$00FF                   ; exitType is only a byte
2626 DC1F C9 04 00              cmp   #4                       ; one of the help terminators?
2627 DC22 90 05                 bcc   @not_help                ; no...
2628 DC24 20 7C DB              jsr   force_message            ; else must have been OA-?
2629 DC27 80 A1                 bra   read_reentry             ; update message and reenter read mode
2630 DC29
2631 DC29              @not_help  
2632 DC29 A8                    tay                            ; save in Y
2633 DC2A A5 B6                 lda   <init_temp_4             ; get the returned length
2634 DC2C E2 20                 sep   #$20                     ; 8-bit store
2635 DC2E 87 C6                 sta   [<txt_name_ptr]          ; set new string length
2636 DC30 C2 20                 rep   #$20
2637 DC32
2638 DC32 A2 00 00              ldx   #0                       ; assume user entered 'ok'
2639 DC35 88                    dey                            ; was it terminator #1?
2640 DC36 F0 0C                 beq   @accept_terminator       ; yes...
2641 DC38 E8                    inx                            ; else make X = 1
2642 DC39 88                    dey                            ; was it terminator #2 (ESC)?
2643 DC3A F0 08                 beq   @accept_terminator       ; yes...
2644 DC3C              ; else must have been terminator #3 (TAB)
2645 DC3C C6 BA                 dec   <top_bar_pos             ; was 0, now -1 to highlight the FST list
2646 DC3E 20 6E D6              jsr   draw_top_select          ; update the highlighting
2647 DC41 A2 FF FF              ldx   #-1                      ; re-init init_choice
2648 DC44              @accept_terminator  
2649 DC44 60                    rts                            ; back to the 'event handler' loop
2650 DC45
2651 DC45                       endp 
2652 DC45
2653 DC45                       eject 
2654 DC45              ;==========================================================
2655 DC45              ;
2656 DC45              ;  text_loop
2657 DC45              ;
2658 DC45              ;  Event loop for the text display.  Waits for keystrokes,
2659 DC45              ;  processes them until return or esc pressed.
2660 DC45              ;
2661 DC45              ;  Outputs:     init_choice = 0 if ok pressed,
2662 DC45              ;                             1 if cancel
2663 DC45              ;               A = trashed
2664 DC45              ;               X = trashed
2665 DC45              ;               Y = trashed
2666 DC45              ;               P = nvmxdizc
2667 DC45              ;                   ..000...
2668 DC45              ;
2669 DC45              ;==========================================================
2670 DC45
2671 DC45              text_loop Proc 
2672 DC45                       Import get_string
2673 DC45                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2674 DC45                       Import input_port:InputPortRec
2675 DC45
2676 DC45                       with my_direct_page
2677 DC45
2678 DC45 64 A6                 stz   <init_choice             ; set to -1
2679 DC47 C6 A6                 dec   <init_choice
2680 DC49
2681 DC49              text_loop_0  
2682 DC49 A5 A6                 lda   <init_choice             ; done yet?
2683 DC4B 10 0E                 bpl   done
2684 DC4D
2685 DC4D A5 BA                 lda   <top_bar_pos             ; which 'control' is currently active?
2686 DC4F D0 45                 bne   list_current             ; one of the lists...
2687 DC51 20 B0 DB              jsr   handle_edit              ; else go handle the edit 'control'
2688 DC54 86 A6                 stx   <init_choice             ; store the correct value to halt
2689 DC56 8A                    txa                            ; check the returned value
2690 DC57 30 38                 bmi   go_chk_message           ; negative means continue the loop
2691 DC59 D0 35                 bne   name_good                ; != 0 means cancel
2692 DC5B              done      
2693 DC5B A9 D4 D1              lda   #tx_list_1               ; get currently selected FST ID
2694 DC5E 85 BE                 sta   <tx_list_ptr
2695 DC60 A9 01 00              lda   #^tx_list_1
2696 DC63 85 C0                 sta   <tx_list_ptr+2
2697 DC65 AD DE D1              lda   |tx_list_1.current_entry ; get the FST record number
2698 DC68 20 D5 D7              jsr   make_tx_ptr              ; make a pointer to the member record
2699 DC6B 20 DB DA              jsr   tx_check_name            ; go do a JudgeName call
2700 DC6E 90 20                 bcc   name_good                ; checked out OK!
2701 DC70
2702 DC70 2C 4E D2              bit   pb_flags                 ; was it an editable name?
2703 DC73 10 1B                 bpl   name_good                ; no, just let the FST generate an error
2704 DC75
2705 DC75 F4 09 00              pea   $0009                    ; "bad input" beep type
2706 DC78 A2 03 38              ldx   #$3803                   ; SysBeep2
2707 DC7B 22 00 00 E1           jsl   $E10000                  ; get the user's attention
2708 DC7F
2709 DC7F A9 3F 00              lda   #63                      ; message = "The supplied name is unacceptable..."
2710 DC82 8D 1E D0              sta   currentFST
2711 DC85 22 50 D2 01           jsl   get_string               ; go get the message pointer
2712 DC89 20 F7 D5              jsr   txTextBox2               ; draw the caution message
2713 DC8C C6 A6                 dec   <init_choice             ; reset to continue the loop
2714 DC8E 80 B9                 bra   text_loop_0              ; re-enter the event loop
2715 DC90              name_good  
2716 DC90 60                    rts   
2717 DC91
2718 DC91              go_chk_message  
2719 DC91 20 73 DB              jsr   chk_message              ; go update the message box
2720 DC94 80 B3                 bra   text_loop_0              ; then re-enter loop
2721 DC96
2722 DC96              list_current  
2723 DC96 A9 02 00              lda   #drvr_read               ; read 1 char
2724 DC99 85 02                 sta   <drvr_call_num
2725 DC9B AD 0A D0              lda   |cons_dev_num
2726 DC9E 85 00                 sta   <drvr_dev_num
2727 DCA0 A9 B6 B2              lda   #<std_buffer
2728 DCA3 85 04                 sta   <drvr_slist_ptr
2729 DCA5 A9 00 00              lda   #^std_buffer
2730 DCA8 85 06                 sta   <drvr_slist_ptr+2
2731 DCAA A9 01 00              lda   #1
2732 DCAD 85 08                 sta   <drvr_req_cnt
2733 DCAF 64 0A                 stz   <drvr_req_cnt+2
2734 DCB1 22 18 D4 00           jsl   >call_dispatch
2735 DCB5
2736 DCB5              ; case on key pressed
2737 DCB5
2738 DCB5 20 D7 D2              jsr   get_input_port           ; get the InputPort settings
2739 DCB8
2740 DCB8 AF DA B2 00           lda   >input_port.lastChar     ; get the last char and modifier bits
2741 DCBC 29 FF C3              and   #%1100001111111111       ; mask out unimportant modifiers
2742 DCBF C9 09 00              cmp   #$0009                   ; was it a TAB?
2743 DCC2 D0 15                 bne   not_tab
2744 DCC4
2745 DCC4              ; handle tab by rotating through the three 'controls'
2746 DCC4
2747 DCC4              do_tab    
2748 DCC4 A2 01 00              ldx   #1                       ; assume FST list is current control
2749 DCC7 A5 BA                 lda   <top_bar_pos             ; better check, though
2750 DCC9 30 07                 bmi   @1                       ; yup, switch to format list
2751 DCCB CA                    dex                            ; else switch to editLine 'control'
2752 DCCC 2C 4E D2              bit   pb_flags                 ; is the volume name editable?
2753 DCCF 30 01                 bmi   @1                       ; yes, we can activate the control
2754 DCD1 CA                    dex                            ; else simply toggle between lists
2755 DCD2              @1        
2756 DCD2 86 BA                 stx   <top_bar_pos             ; store the new setting
2757 DCD4 20 6E D6              jsr   draw_top_select          ; redraw the highlighting
2758 DCD7 80 B8                 bra   go_chk_message           ; then make sure the right message is displayed
2759 DCD9
2760 DCD9              not_tab   
2761 DCD9 C9 0A 00              cmp   #$0A                     ; down arrow?
2762 DCDC D0 05                 bne   not_down_arrow
2763 DCDE              go_down_arrow  
2764 DCDE 20 EC D9              jsr   do_down_arrow
2765 DCE1 80 AE                 bra   go_chk_message           ; make sure the correct JudgeName prompt is shown
2766 DCE3
2767 DCE3              not_down_arrow  
2768 DCE3 C9 0B 00              cmp   #$0B                     ; up arrow?
2769 DCE6 D0 05                 bne   not_up_arrow
2770 DCE8              go_up_arrow  
2771 DCE8 20 42 DA              jsr   do_up_arrow
2772 DCEB 80 A4                 bra   go_chk_message
2773 DCED
2774 DCED              not_up_arrow  
2775 DCED C9 3F 81              cmp   #$813F                   ; Open_Apple '?'?
2776 DCF0 F0 05                 beq   is_help                  ; yes...
2777 DCF2 C9 2F 80              cmp   #$802F                   ; Open-Apple '/'?
2778 DCF5 D0 0A                 bne   not_help                 ; no...
2779 DCF7              is_help   
2780 DCF7 2C 4E D2              bit   pb_flags                 ; editable name?
2781 DCFA 10 18                 bpl   bad_input                ; no, help not available
2782 DCFC 20 7C DB              jsr   force_message            ; force the display of the JudgeName prompt
2783 DCFF 80 1D                 bra   leapfrog
2784 DD01
2785 DD01              not_help  
2786 DD01 C9 0D 80              cmp   #$800D                   ; Open-Apple return?
2787 DD04 D0 04                 bne   not_return               ; no, try something else
2788 DD06 64 A6                 stz   <init_choice             ; signal return
2789 DD08 80 14                 bra   leapfrog
2790 DD0A
2791 DD0A              not_return  
2792 DD0A C9 1B 00              cmp   #$001B                   ; escape?
2793 DD0D D0 05                 bne   bad_input                ; nothing else is legal
2794 DD0F
2795 DD0F E6 A6                 inc   <init_choice             ; signal esc
2796 DD11 E6 A6                 inc   <init_choice
2797 DD13 60                    rts   
2798 DD14
2799 DD14              bad_input  
2800 DD14              ;  illegal key.  beep and loop.
2801 DD14 F4 08 00              pea   8                        ; bad keypress
2802 DD17 A2 03 38              ldx   #$3803                   ; sysbeep2
2803 DD1A 22 00 00 E1           jsl   $E10000
2804 DD1E              leapfrog  
2805 DD1E 82 28 FF              brl   text_loop_0
2806 DD21
2807 DD21                       EndP 
2808 DD21
2809 DD21                       eject 
2810 DD21              ;==========================================================
2811 DD21              ;
2812 DD21              ;  preset_choices
2813 DD21              ;
2814 DD21              ;  Pick the defaults, by (1) attempting to choose the
2815 DD21              ;  driver default format (see choose_fmt for details) and
2816 DD21              ;  (2) taking the 1st FST listed by that format.
2817 DD21              ;
2818 DD21              ;  Outputs:     A = trashed
2819 DD21              ;               X = trashed
2820 DD21              ;               Y = trashed
2821 DD21              ;               P = nvmxdizc
2822 DD21              ;                   ..000...
2823 DD21              ;
2824 DD21              ;==========================================================
2825 DD21
2826 DD21              preset_choices Proc 
2827 DD21                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2828 DD21                       Import jsl_fst_ptr,fst_adj_fmts
2829 DD21
2830 DD21                       with my_direct_page,fmt_list_record,fst_list_record
2831 DD21
2832 DD21 20 8B D9              jsr   choose_fmt               ; picks a default format
2833 DD24
2834 DD24 AD 4C D2              lda   pb_reqFileSysID          ; valid FST ID supplied?
2835 DD27 D0 10                 bne   set_default              ; yes, use it as initial selection
2836 DD29
2837 DD29              ; At this point, the supplied FST ID is 0.  This means that the caller doesn't
2838 DD29              ; really care what the initially selected FST is.  So, since the first FST in the
2839 DD29              ; list is the boot FST, we should make sure that it's the one that is initially
2840 DD29              ; selected.  (Well, we should supply SOME kinda default, shouldn't we?)
2841 DD29
2842 DD29 AD EE D1              lda   |tx_list_2.current_entry ; get that format's FST
2843 DD2C 20 D5 D7              jsr   make_tx_ptr
2844 DD2F A0 08 00              ldy   #df_one_fst
2845 DD32 B7 C2                 lda   [<tx_entry_ptr],y
2846 DD34 8D DE D1              sta   |tx_list_1.current_entry ; and select that fst
2847 DD37 80 70                 bra   draw_lists               ; then go draw the lists
2848 DD39
2849 DD39              set_default  
2850 DD39 A9 D4 D1              lda   #<tx_list_1              ; use the FST list
2851 DD3C 85 BE                 sta   <tx_list_ptr
2852 DD3E A9 01 00              lda   #^tx_list_1
2853 DD41 85 C0                 sta   <tx_list_ptr+2
2854 DD43 A9 00 00              lda   #0                       ; start at the beginning of the list
2855 DD46              @loop     
2856 DD46 85 AA                 sta   init_temp_1              ; save the member #
2857 DD48 20 D5 D7              jsr   make_tx_ptr              ; go make a pointer
2858 DD4B A0 08 00              ldy   #ff_fs_num               ; get the FST ID from the record
2859 DD4E B7 C2                 lda   [<tx_entry_ptr],y
2860 DD50 CD 4C D2              cmp   pb_reqFileSysID          ; do they match?
2861 DD53 F0 11                 beq   @select_it               ; yes, select it
2862 DD55 2C 4E D2              bit   pb_flags                 ; is the FST selectable?
2863 DD58 70 20                 bvs   @next_one                ; yes, leave the entry as is
2864 DD5A A0 04 00              ldy   #ff_mem_flag             ; else dim it
2865 DD5D B7 C2                 lda   [<tx_entry_ptr],y
2866 DD5F 09 20 00              ora   #%00100000
2867 DD62 97 C2                 sta   [<tx_entry_ptr],y
2868 DD64 80 14                 bra   @next_one
2869 DD66              @select_it  
2870 DD66 A0 04 00              ldy   #ff_mem_flag             ; set the selected bit
2871 DD69 B7 C2                 lda   [<tx_entry_ptr],y
2872 DD6B 89 60 00              bit   #%01100000               ; first, is it selectable?
2873 DD6E D0 0A                 bne   @next_one                ; no, so don't select it
2874 DD70 09 80 00              ora   #%10000000
2875 DD73 97 C2                 sta   [<tx_entry_ptr],y
2876 DD75 A5 AA                 lda   <init_temp_1             ; get the current index
2877 DD77 8D DE D1              sta   tx_list_1.current_entry  ; set the current selection
2878 DD7A              @next_one  
2879 DD7A A5 AA                 lda   init_temp_1              ; bump counter
2880 DD7C 1A                    inc   a                        ; are we done yet?
2881 DD7D C5 9C                 cmp   fst_list_cnt
2882 DD7F D0 C5                 bne   @loop                    ; no, go do the next one
2883 DD81
2884 DD81 AD DE D1              lda   tx_list_1.current_entry  ; did anything get selected?
2885 DD84 10 23                 bpl   draw_lists               ; yes...
2886 DD86 A9 00 00              lda   #0                       ; else scan the list again, looking for
2887 DD89              @loop2    
2888 DD89 85 AA                 sta   <init_temp_1             ;  the first selectable FST
2889 DD8B 20 D5 D7              jsr   make_tx_ptr
2890 DD8E A0 04 00              ldy   #ff_mem_flag             ; get the flags
2891 DD91 B7 C2                 lda   [<tx_entry_ptr],y
2892 DD93 89 60 00              bit   #%01100000               ; is it selectable?
2893 DD96 F0 07                 beq   @got_it                  ; yes, go select it
2894 DD98 A5 AA                 lda   <init_temp_1
2895 DD9A 1A                    inc   a
2896 DD9B C5 9C                 cmp   fst_list_cnt
2897 DD9D D0 EA                 bne   @loop2
2898 DD9F
2899 DD9F              @got_it   
2900 DD9F 09 80 00              ora   #%10000000               ; set the selected bit
2901 DDA2 97 C2                 sta   [<tx_entry_ptr],y
2902 DDA4 A5 AA                 lda   <init_temp_1
2903 DDA6 8D DE D1              sta   tx_list_1.current_entry
2904 DDA9              draw_lists  
2905 DDA9 AD DE D1              lda   tx_list_1.current_entry
2906 DDAC 22 91 D4 00           jsl   jsl_fst_ptr              ; make a pointer to the entry
2907 DDB0 22 A4 DB 00           jsl   fst_adj_fmts             ; disable any inappropriate formats
2908 DDB4
2909 DDB4 A9 D4 D1              lda   #<tx_list_1
2910 DDB7 85 BE                 sta   <tx_list_ptr
2911 DDB9 A9 01 00              lda   #^tx_list_1
2912 DDBC 85 C0                 sta   <tx_list_ptr+2
2913 DDBE
2914 DDBE 82 7C FA              brl   draw_list
2915 DDC1                       EndP 
2916 DDC1
2917 DDC1                       eject 
2918 DDC1              ;==========================================================
2919 DDC1              ;
2920 DDC1              ;  record_tx_sel
2921 DDC1              ;
2922 DDC1              ;  Convert list selections to chosen_fst and chosen_fmt.
2923 DDC1              ;
2924 DDC1              ;  Outputs:     chosen_fst = entry # of selected FST
2925 DDC1              ;               chosen_fmt = entry # of selected format
2926 DDC1              ;               A = trashed
2927 DDC1              ;               X = trashed
2928 DDC1              ;               Y = trashed
2929 DDC1              ;               P = nvmxdizc
2930 DDC1              ;                   ..000...
2931 DDC1              ;
2932 DDC1              ;==========================================================
2933 DDC1
2934 DDC1              record_tx_sel Proc 
2935 DDC1                       Import tx_list_1:tx_list_record,tx_list_2:tx_list_record
2936 DDC1                       with my_direct_page,fst_list_record
2937 DDC1
2938 DDC1 A9 D4 D1              lda   #tx_list_1
2939 DDC4 85 BE                 sta   <tx_list_ptr
2940 DDC6 A9 01 00              lda   #^tx_list_1
2941 DDC9 85 C0                 sta   <tx_list_ptr+2
2942 DDCB AD DE D1              lda   |tx_list_1.current_entry
2943 DDCE 20 D5 D7              jsr   make_tx_ptr              ; make pointer to FST list record
2944 DDD1 A0 08 00              ldy   #ff_fs_num               ; get the FST ID
2945 DDD4 B7 C2                 lda   [<tx_entry_ptr],y
2946 DDD6 85 A2                 sta   <chosen_fst
2947 DDD8
2948 DDD8 AD EE D1              lda   |tx_list_2.current_entry ; fmt
2949 DDDB 85 A4                 sta   <chosen_fmt
2950 DDDD
2951 DDDD              ; now we have to fix up the name so that it's in the proper format
2952 DDDD
2953 DDDD A5 C6                 lda   <txt_name_ptr            ; get source pointer
2954 DDDF A6 C8                 ldx   <txt_name_ptr+2
2955 DDE1
2956 DDE1 AC 00 D0              ldy   which_class              ; class 1?
2957 DDE4 D0 05                 bne   @class1                  ; yes, go handle it
2958 DDE6 1A                    inc   a                        ; else bump by 1 to make room for
2959 DDE7 D0 09                 bne   do_copy                  ; ..leading separator
2960 DDE9 F0 06                 beq   @bump_high_word
2961 DDEB
2962 DDEB              @class1   
2963 DDEB 18                    clc                            ; class 1, leading separator &
2964 DDEC 69 02 00              adc   #2                       ; ..high byte of length word
2965 DDEF 90 01                 bcc   do_copy
2966 DDF1              @bump_high_word  
2967 DDF1 E8                    inx   
2968 DDF2              do_copy   
2969 DDF2 85 B6                 sta   <init_temp_4             ; store as destination pointer
2970 DDF4 86 B8                 stx   <init_temp_4+2
2971 DDF6 A7 C6                 lda   [<txt_name_ptr]          ; get length
2972 DDF8 29 FF 00              and   #$00FF                   ; clear garbage byte
2973 DDFB F0 1B                 beq   @class_1                 ; if null, skip the copy
2974 DDFD 48                    pha                            ; save length
2975 DDFE A8                    tay                            ; put into Y for indexing
2976 DDFF E2 20                 sep   #$20                     ; 8-bit accumulator
2977 DE01                       longa off
2978 DE01
2979 DE01              @loop     
2980 DE01 B7 C6                 lda   [<txt_name_ptr],y        ; move up within buffer
2981 DE03 97 B6                 sta   [<init_temp_4],y
2982 DE05 88                    dey   
2983 DE06 D0 F9                 bne   @loop
2984 DE08 A9 3A                 lda   #':'                     ; leading separator
2985 DE0A 87 B6                 sta   [<init_temp_4]
2986 DE0C C2 20                 rep   #$20                     ; 16-bit accumulator again
2987 DE0E                       longa on
2988 DE0E 68                    pla                            ; retrieve length
2989 DE0F 1A                    inc   a                        ; bump by 1 to account for separator
2990 DE10 AC 00 D0              ldy   which_class              ; class 1 call needs a word length
2991 DE13 D0 03                 bne   @class_1
2992 DE15 09 00 2F              ora   #'/'<<8                  ; else combine with class 0 separator
2993 DE18              @class_1  
2994 DE18 87 C6                 sta   [<txt_name_ptr]          ; store the length
2995 DE1A 60                    rts                            ; and we're done
2996 DE1B                       EndP 
2997 DE1B
2998 DE1B                       eject 
2999 DE1B              ;==========================================================
3000 DE1B              ;
3001 DE1B              ;  display_msg
3002 DE1B              ;
3003 DE1B              ;  Displays a graphics or text message which says 'Initializing...'.
3004 DE1B              ;
3005 DE1B              ;  Inputs:      none
3006 DE1B              ;
3007 DE1B              ;  Outputs:     A = trashed
3008 DE1B              ;               X = trashed
3009 DE1B              ;               Y = trashed
3010 DE1B              ;               P = nvmxdizc
3011 DE1B              ;                   ..000...
3012 DE1B              ;
3013 DE1B              ;  Added CAE 12/21/88
3014 DE1B              ;  Modified CAE 7/27/89 to fix a bug in which |cons_dev_num was
3015 DE1B              ;       not initialized if doing a non-dialog Format in text mode.
3016 DE1B              ;
3017 DE1B              ;==========================================================
3018 DE1B
3019 DE1B              display_msg Proc Export
3020 DE1B                       longa on
3021 DE1B                       longi on
3022 DE1B                       Import get_string
3023 DE1B                       with my_direct_page
3024 DE1B
3025 DE1B AD 4E D2              lda   pb_flags                 ;get the flags
3026 DE1E 89 00 20              bit   #%0010000000000000       ;caller wishes to inhibit the window?
3027 DE21 F0 01                 beq   @show_window             ;no, go ahead and display it
3028 DE23 6B                    rtl                            ;else just short circuit it
3029 DE24
3030 DE24              @show_window  
3031 DE24 A5 A8                 lda   <init_screen
3032 DE26 10 71                 bpl   do_text_msg
3033 DE28
3034 DE28              ;put up a graphics message
3035 DE28
3036 DE28 EE 10 D0              inc   |msg_flag                ;indicate that a graphics message was put up
3037 DE2B
3038 DE2B              ; save caller's cursor, and set it to the watch cursor
3039 DE2B
3040 DE2B 48                    pha   
3041 DE2C 48                    pha   
3042 DE2D A2 04 8F              ldx   #$8F04                   ; GetCursorAdr
3043 DE30 22 00 00 E1           jsl   >$e10000
3044 DE34 68                    pla   
3045 DE35 8D 06 D0              sta   |save_cursor
3046 DE38 68                    pla   
3047 DE39 8D 08 D0              sta   |save_cursor+2
3048 DE3C
3049 DE3C A2 12 0A              ldx   #$0A12                   ;WaitCursor
3050 DE3F 22 00 00 E1           jsl   $E10000                  ;(no effect if QDAux not set up)
3051 DE43
3052 DE43 48                    pha                            ;space for result
3053 DE44 48                    pha   
3054 DE45 F4 01 00              pea   msg_parms>>16
3055 DE48 F4 92 D0              pea   msg_parms
3056 DE4B A2 0E 09              ldx   #$090E                   ;NewWindow
3057 DE4E 22 00 00 E1           jsl   >$e10000
3058 DE52 68                    pla   
3059 DE53 8D 12 D0              sta   |msg_window
3060 DE56 68                    pla   
3061 DE57 8D 14 D0              sta   |msg_window+2
3062 DE5A
3063 DE5A 48                    pha                            ; save old port
3064 DE5B 48                    pha   
3065 DE5C A2 04 1C              ldx   #$1C04                   ; GetPort
3066 DE5F 22 00 00 E1           jsl   >$e10000
3067 DE63 68                    pla   
3068 DE64 8D 16 D0              sta   |save_port
3069 DE67 68                    pla   
3070 DE68 8D 18 D0              sta   |save_port+2
3071 DE6B
3072 DE6B AD 14 D0              lda   |msg_window+2            ; set new port
3073 DE6E 48                    pha   
3074 DE6F AD 12 D0              lda   |msg_window
3075 DE72 48                    pha   
3076 DE73 A2 04 1B              ldx   #$1B04                   ; SetPort
3077 DE76 22 00 00 E1           jsl   >$e10000
3078 DE7A
3079 DE7A F4 2D 00              pea   45
3080 DE7D F4 0E 00              pea   14
3081 DE80 A2 04 3A              ldx   #$3A04                   ;MoveTo
3082 DE83 22 00 00 E1           jsl   >$e10000
3083 DE87
3084 DE87 A9 29 00              lda   #41
3085 DE8A 22 50 D2 01           jsl   get_string
3086 DE8E 5A                    phy   
3087 DE8F DA                    phx   
3088 DE90 A2 04 A5              ldx   #$A504                   ;DrawString
3089 DE93 22 00 00 E1           jsl   >$e10000
3090 DE97
3091 DE97 80 5C                 bra   done
3092 DE99
3093 DE99              ;put up a text message
3094 DE99
3095 DE99              do_text_msg  
3096 DE99 20 3F D3              jsr   find_console             ; get device # of .CONSOLE      ** added 7/27/89 CAE **
3097 DE9C B0 57                 bcs   done                     ; got an error                  ** added 7/27/89 CAE **
3098 DE9E
3099 DE9E CE 10 D0              dec   |msg_flag                ;indicate that a text message was put up
3100 DEA1
3101 DEA1 20 94 D3              jsr   save_state               ; save video mode state
3102 DEA4 20 CD D3              jsr   save_cons_state          ; save console driver state
3103 DEA7 20 4C D5              jsr   save_tx_screen           ; save current text screen
3104 DEAA
3105 DEAA A9 01 02              lda   #$0201                   ; push vp, set vp
3106 DEAD 20 F3 D2              jsr   write_2char
3107 DEB0 A9 3A 2A              lda   #$2A3A                   ; 26, 10
3108 DEB3 20 F3 D2              jsr   write_2char
3109 DEB6 A9 56 2D              lda   #$2D56                   ; 54, 13
3110 DEB9 20 F3 D2              jsr   write_2char
3111 DEBC A9 15 17              lda   #$1715                   ; disable scroll
3112 DEBF 20 F3 D2              jsr   write_2char
3113 DEC2
3114 DEC2 A9 1B 00              lda   #27                      ; width
3115 DEC5 20 9F D6              jsr   write_line               ; draw top line
3116 DEC8
3117 DEC8 A9 03 00              lda   #3                       ; sides counter
3118 DECB 85 AE                 sta   <init_temp_2
3119 DECD A9 DA 10     side_loop lda   #$10DA                  ; side bar, expand spaces
3120 DED0 20 F3 D2              jsr   write_2char
3121 DED3 A9 3B DF              lda   #$DF3B                   ; 27 spaces, side bar
3122 DED6 20 F3 D2              jsr   write_2char
3123 DED9 C6 AE                 dec   <init_temp_2
3124 DEDB D0 F0                 bne   side_loop
3125 DEDD
3126 DEDD A9 1B 00              lda   #27                      ; width
3127 DEE0 20 9F D6              jsr   write_line               ; draw bottom line
3128 DEE3
3129 DEE3 A9 1E 00 20           _gotoxy 7,2
3130 DEEF
3131 DEEF A9 29 00              lda   #41
3132 DEF2 20 ED D2              jsr   write_num_str            ; write out the string
3133 DEF5
3134 DEF5 6B           done     rtl   
3135 DEF6                       EndP 
3136 DEF6
3137 DEF6                       eject 
3138 DEF6              ;==========================================================
3139 DEF6              ;
3140 DEF6              ;  remove_msg
3141 DEF6              ;
3142 DEF6              ;  Removes the 'Initializing...' message.
3143 DEF6              ;
3144 DEF6              ;  Inputs:      none
3145 DEF6              ;
3146 DEF6              ;  Outputs:     A = trashed
3147 DEF6              ;               X = trashed
3148 DEF6              ;               Y = trashed
3149 DEF6              ;               P = nvmxdizc
3150 DEF6              ;                   ..000...
3151 DEF6              ;
3152 DEF6              ;  Added 1/9/88 CAE
3153 DEF6              ;
3154 DEF6              ;==========================================================
3155 DEF6
3156 DEF6              remove_msg Proc Export
3157 DEF6                       longa on
3158 DEF6                       longi on
3159 DEF6
3160 DEF6 8B                    phb                            ; remember gs/os data bank
3161 DEF7 F4 01 01              pea   $0101                    ; our data is in bank 1
3162 DEFA AB                    plb   
3163 DEFB AB                    plb   
3164 DEFC
3165 DEFC AD 10 D0              lda   |msg_flag                ;did we put a message up?
3166 DEFF F0 3A                 beq   rmv_done                 ;no - so nothing to remove
3167 DF01 30 2F                 bmi   remove_text_msg          ;yes - it was a text message
3168 DF03
3169 DF03              ;remove a graphics message
3170 DF03
3171 DF03 AD 18 D0              lda   |save_port+2             ;restore the original port
3172 DF06 48                    pha   
3173 DF07 AD 16 D0              lda   |save_port
3174 DF0A 48                    pha   
3175 DF0B A2 04 1B              ldx   #$1B04                   ; SetPort
3176 DF0E 22 00 00 E1           jsl   >$e10000
3177 DF12
3178 DF12 AD 14 D0              lda   |msg_window+2            ;remove the message window
3179 DF15 48                    pha   
3180 DF16 AD 12 D0              lda   |msg_window
3181 DF19 48                    pha   
3182 DF1A A2 0E 0B              ldx   #$0B0E                   ; CloseWindow
3183 DF1D 22 00 00 E1           jsl   >$e10000
3184 DF21
3185 DF21 AD 08 D0              lda   |save_cursor+2           ;restore caller's original cursor
3186 DF24 48                    pha   
3187 DF25 AD 06 D0              lda   |save_cursor
3188 DF28 48                    pha   
3189 DF29 A2 04 8E              ldx   #$8E04
3190 DF2C 22 00 00 E1           jsl   >$e10000
3191 DF30
3192 DF30 80 09                 bra   rmv_done
3193 DF32
3194 DF32              ;remove a text message
3195 DF32
3196 DF32 20 AF D5     remove_text_msg jsr   restore_tx_scr    ; restore the original text screen
3197 DF35 20 B3 D4              jsr   restore_console          ; restore console driver to its original state
3198 DF38 20 56 D3              jsr   restore_state            ; restore original video mode
3199 DF3B
3200 DF3B AB           rmv_done plb                            ;restore gs/os data bank register
3201 DF3C 6B                    rtl   
3202 DF3D                       EndP 
3203 DF3D
3204 DF3D                       Eject 
3205 DF3D              ;==========================================================
3206 DF3D              ;
3207 DF3D              ;  non_dialog
3208 DF3D              ;
3209 DF3D              ;  The calling program specified which FST to use in the
3210 DF3D              ;  parameter block so all we need to do is get the default
3211 DF3D              ;  format for the device.
3212 DF3D              ;
3213 DF3D              ;  Inputs:      fmt_list_vp = vp of the format options list
3214 DF3D              ;               fst_list_vp = vp of the file system options
3215 DF3D              ;
3216 DF3D              ;  Outputs:     chosen_fst = selected fst #
3217 DF3D              ;               chosen_fmt = selected fmt #
3218 DF3D              ;               init_choice = 0
3219 DF3D              ;               A = error # if c=1
3220 DF3D              ;               X = trashed
3221 DF3D              ;               Y = trashed
3222 DF3D              ;               P = nvmxdizc
3223 DF3D              ;                   ..000..|
3224 DF3D              ;                          0=no error, 1=error
3225 DF3D              ;
3226 DF3D              ;  This routine added 4-88 CAE
3227 DF3D              ;==========================================================
3228 DF3D
3229 DF3D              non_dialog Proc Export
3230 DF3D                       Import choose_def_fmt2,jsl_fst_ptr,jsl_deref
3231 DF3D                       with my_direct_page,fst_list_record
3232 DF3D
3233 DF3D                       longa on
3234 DF3D                       longi on
3235 DF3D
3236 DF3D 9C 20 D0              stz   path_vp                  ;make sure we return a NULL VP
3237 DF40 9C 22 D0              stz   path_vp+2                ;  for the volume name
3238 DF43
3239 DF43              ; first, get the FST ID # specified in the call
3240 DF43
3241 DF43 A0 0C 00              ldy   #$000c                   ;offset to requested FST field
3242 DF46 B7 32                 lda   [<param_blk_ptr],y       ;get requested FST
3243 DF48 D0 05                 bne   @1                       ;non zero means look for it
3244 DF4A A9 64 00              lda   #invalid_fst_id          ;zero is a bad FST ID #
3245 DF4D 38                    sec   
3246 DF4E 6B                    rtl   
3247 DF4F              @1        
3248 DF4F 48                    pha                            ;save on stack
3249 DF50
3250 DF50              ; now search through the list to find the specified FST ID and ensure that
3251 DF50              ; the FST supports formatting.
3252 DF50
3253 DF50 22 77 D2 01           jsl   deref_lists
3254 DF54 64 AA                 stz   <init_temp_1             ;entry counter
3255 DF56
3256 DF56              xlate_fst  
3257 DF56 A5 AA                 lda   <init_temp_1
3258 DF58 22 91 D4 00           jsl   jsl_fst_ptr              ;create ptr to fst entry
3259 DF5C A0 08 00              ldy   #ff_fs_num
3260 DF5F B7 98                 lda   [<fst_list_entry],y      ;get FST ID # from entry
3261 DF61 C3 01                 cmp   1,s                      ;does it match the requested FST ID #?
3262 DF63 F0 0D                 beq   xlate_done               ;yes - so we found the correct entry
3263 DF65 E6 AA                 inc   <init_temp_1             ;no - so check the next entry
3264 DF67 A5 AA                 lda   <init_temp_1
3265 DF69 C5 9C                 cmp   <fst_list_cnt            ;at end of list?
3266 DF6B D0 E9                 bne   xlate_fst                ;no
3267 DF6D 68                    pla                            ;yes - so clean up stack
3268 DF6E A9 65 00              lda   #invalid_fst_op          ;return error
3269 DF71 6B                    rtl                            ;carry is set
3270 DF72
3271 DF72              xlate_done  
3272 DF72 68                    pla                            ;clean up stack
3273 DF73 85 A2                 sta   <chosen_fst              ;save fst id
3274 DF75
3275 DF75              ; now enable the available formats for this FST
3276 DF75
3277 DF75 22 A4 DB 00           jsl   fst_adj_fmts
3278 DF79
3279 DF79              ; now select the default format
3280 DF79
3281 DF79 22 60 DB 00           jsl   choose_def_fmt2
3282 DF7D B0 07                 bcs   @oops                    ;if error occurs, exit
3283 DF7F
3284 DF7F              ; now set up the correct outputs
3285 DF7F
3286 DF7F A5 AA                 lda   <init_temp_1             ;record item #
3287 DF81 85 A4                 sta   <chosen_fmt              ;format ref #
3288 DF83 64 A6                 stz   <init_choice
3289 DF85 18                    clc                            ;indicate no error
3290 DF86              @oops     
3291 DF86 6B                    rtl   
3292 DF87                       EndP 
3293 DF87
3294 DF87                       eject 
3295 DF87              ;==========================================================
3296 DF87              ;
3297 DF87              ;  init.tx
3298 DF87              ;
3299 DF87              ;  Text based user interface for the init package.  Puts
3300 DF87              ;  up a dialog window and prompts the user for selection
3301 DF87              ;  of formatting options.
3302 DF87              ;
3303 DF87              ;  Author:      Andy Stadler
3304 DF87              ;  Created:     31-Jan-88
3305 DF87              ;  Modified:    See modification history below
3306 DF87              ;
3307 DF87              ;  Copyright Apple Computer, Inc. 1987-1989
3308 DF87              ;  All rights reserved.
3309 DF87              ;
3310 DF87              ;==========================================================
3311 DF87              ;
3312 DF87              ;  Modification history:
3313 DF87              ;
3314 DF87              ;  15-Feb-88    ADS     Initial release
3315 DF87              ;  23-Feb-88    ADS     General crunching
3316 DF87              ;                       'Format too large' indicator added
3317 DF87              ;  30-Mar-88    CAE     Changed to use strings which say
3318 DF87              ;                       'Format' or 'Erase' instead of 'Initialize'
3319 DF87              ;  12-Jan-89    CAE     Renamed some routines and moved some code around 
3320 DF87              ;  13-Jan-89    CAE     Modified write_line routine to take # of chars as input
3321 DF87              ;  08-Feb-89    CAE     Added error check in tx_dialog after calling find_console.
3322 DF87              ;                       Changed find_console to ask for the device # of the device 
3323 DF87              ;                       named "CONSOLE" instead of just searching DIBs for a console device.
3324 DF87              ;==========================================================
3325 DF87
3326 DF87              ;==========================================================
3327 DF87              ;
3328 DF87              ;  jsl tx_dialog
3329 DF87              ;
3330 DF87              ;  Main level for the text-based user interface.  Saves
3331 DF87              ;  the state of the screen hardware and the console driver,
3332 DF87              ;  then takes over, displaying text mode, drawing a window,
3333 DF87              ;  and showing all the info within the window.
3334 DF87              ;
3335 DF87              ;  Inputs:      fmt_list_vp = vp of the format options list
3336 DF87              ;               fst_list_vp = vp of the file system options
3337 DF87              ;
3338 DF87              ;  Outputs:     chosen_fst = selected fst # if init_choice = 0
3339 DF87              ;               chosen_fmt = selected fmt # if init_choice = 0
3340 DF87              ;               init_choice = 0=OK, 1=cancel
3341 DF87              ;               A = error code if c=1 else trashed
3342 DF87              ;               X = trashed
3343 DF87              ;               Y = trashed
3344 DF87              ;               P = nvmxdizc
3345 DF87              ;                   ..000..|
3346 DF87              ;                          0 = no error; 1 = error
3347 DF87              ;
3348 DF87              ;==========================================================
3349 DF87
3350 DF87              tx_dialog Proc Export
3351 DF87                       Import fix_ptrs,call_alloc
3352 DF87
3353 DF87                       with my_direct_page
3354 DF87
3355 DF87                       longa on
3356 DF87                       longi on
3357 DF87
3358 DF87 20 3F D3              jsr   find_console             ; get device # of .CONSOLE
3359 DF8A B0 36                 bcs   tx_dialog_done           ; got an error
3360 DF8C 20 94 D3              jsr   save_state               ; save video mode state
3361 DF8F 20 CD D3              jsr   save_cons_state          ; save console driver state
3362 DF92 20 4C D5              jsr   save_tx_screen           ; save current text sreen
3363 DF95 A9 24 00              lda   #36                      ; allocate 36 bytes for name
3364 DF98 22 00 D4 00           jsl   call_alloc
3365 DF9C 8E 20 D0              stx   path_vp
3366 DF9F 8C 22 D0              sty   path_vp+2
3367 DFA2 22 65 D7 00           jsl   >fix_ptrs                ; lock memory, make str ptrs
3368 DFA6 20 B7 D6              jsr   setup_name               ; fill our name buffer
3369 DFA9 20 08 D7              jsr   draw_tx_wind             ; draw the window
3370 DFAC
3371 DFAC 20 F4 D7              jsr   setup_lists              ; plug in data & draw
3372 DFAF 20 21 DD              jsr   preset_choices           ; select some defaults
3373 DFB2
3374 DFB2 20 45 DC              jsr   text_loop
3375 DFB5
3376 DFB5 20 AF D5              jsr   restore_tx_scr           ; restore original text screen
3377 DFB8 20 B3 D4              jsr   restore_console          ; restore console driver state
3378 DFBB 20 56 D3              jsr   restore_state            ; restore video mode state
3379 DFBE 20 C1 DD              jsr   record_tx_sel            ; retrieve the settings
3380 DFC1 18                    clc                            ; indicate no error
3381 DFC2
3382 DFC2 6B           tx_dialog_done rtl   
3383 DFC3                       EndP 
3384 DFC3
3385 DFC3                       END   
